package com.anf.ws.ar.services;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class OrgIdFormatter {

	public static final Set<String> identityTypeReferences=new TreeSet<>(List.of("VAT","NTR","PSD","LEI"));
	public static final Set<String> countryCodes=new TreeSet<>(List.of(Locale.getISOCountries()));
	

	public static boolean isFormatted(String cif,String... otherReferences ) {
		int sepIndex = cif.indexOf("-");
		if(sepIndex!=-1) {
			String prefix=cif.substring(0,sepIndex);
			if(prefix.length()>2){
				String country=prefix.substring(prefix.length()-2);
				if(countryCodes.contains(country)) {
					String id=prefix.substring(0,prefix.length()-2);
					if(prefix.length()==5) {
						return identityTypeReferences.contains(id) || 
								otherReferences!=null && List.of(otherReferences).contains(id);
					}
					return otherReferences!=null && List.of(otherReferences).contains(id);					
				}
			}
		}
		return false;
	}
	
	public static String fix(String cif,String identifier,String country){
		if(isFormatted(cif))
			return cif;
//		cif = clean(cif);
		cif=identifier+country+"-"+cif;
		return cif;
		
	}

	public static String clean(String cif) {
		int sepIndex = cif.indexOf("-");
		if(sepIndex!=-1 && sepIndex<cif.length()-1) {
			cif=cif.substring(sepIndex+1);			
		}
		return cif;
	}
}
