/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.view.model;

import com.anf.autoupdate.client.model.FileAction;
import com.anf.autoupdate.client.model.FileVersion;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class FileUpdateItem
extends Label {
    static final Image delete = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("com/anf/autoupdate/client/images/delete.png"), 20.0, 20.0, true, true);
    static final Image add = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("com/anf/autoupdate/client/images/add.png"), 20.0, 20.0, true, true);
    static final Image update = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("com/anf/autoupdate/client/images/update.png"), 20.0, 20.0, true, true);
    static final Image success = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("com/anf/autoupdate/client/images/success.png"), 20.0, 20.0, true, true);
    static final Image error = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("com/anf/autoupdate/client/images/error.png"), 20.0, 20.0, true, true);
    static final Image downloading = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("com/anf/autoupdate/client/images/downloading.png"), 20.0, 20.0, true, true);
    private FileVersion file;

    public FileUpdateItem(FileVersion file) {
        super(file.getPath());
        this.file = file;
        this.setStatus(file.getAction());
    }

    public FileVersion getFile() {
        return this.file;
    }

    private void setStatus(FileAction action) {
        switch (action) {
            case ADD: {
                this.setImage(add);
                break;
            }
            case DELETE: {
                this.setImage(delete);
                break;
            }
            case UPDATE: {
                this.setImage(update);
                break;
            }
        }
    }

    public void setSuccess() {
        this.setImage(success);
    }

    public void setError(String msg) {
        this.setImage(error);
        this.setTooltip(new Tooltip(msg));
    }

    public void setDownloading() {
        this.setImage(downloading);
    }

    private void setImage(Image img) {
        if (Platform.isFxApplicationThread()) {
            this.setGraphic((Node)new ImageView(img));
        } else {
            Platform.runLater(() -> this.setGraphic((Node)new ImageView(img)));
        }
    }
}

