/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.view.messages;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;

public class Toast {
    static String enabledBtnStyle = "-fx-background-radius: 15pt; -fx-border-radius: 15; -fx-border-color: transparent; -fx-background-color: #ececec; -fx-text-fill: white";

    private Toast() {
    }

    private static Popup createPopup(String message) {
        Popup popup = new Popup();
        popup.setAutoFix(true);
        Label label = new Label(message);
        label.getStylesheets().add((Object)ClassLoader.getSystemClassLoader().getResource("popup.css").toExternalForm());
        label.getStyleClass().add((Object)"popup");
        label.setText("  " + label.getText() + "  ");
        popup.getContent().add((Object)label);
        return popup;
    }

    public static void show(String message, Control control) {
        Toast.show(message, control, () -> {});
    }

    public static void show(String message, Control control, Runnable onFinish) {
        Stage stage = (Stage)control.getScene().getWindow();
        Popup popup = Toast.createPopup(message);
        popup.setOnShown(e -> {
            popup.setX(stage.getX() + stage.getWidth() / 2.0 - popup.getWidth() / 2.0);
            popup.setY(stage.getY() + stage.getHeight() / 1.2 - popup.getHeight() / 2.0);
        });
        popup.show((Window)stage);
        new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)((double)message.length() * 50.0)), ae -> {
            popup.hide();
            if (onFinish != null) {
                onFinish.run();
            }
        }, new KeyValue[0])}).play();
    }
}

