/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.view.messages;

import com.anf.autoupdate.text.Texts;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class MessageUtils {
    public static ButtonType showConfirmMsg(Stage stage, String header) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initStyle(StageStyle.UNDECORATED);
        alert.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
        alert.initOwner((Window)stage);
        alert.setHeaderText(header);
        Button btOk = (Button)alert.getDialogPane().lookupButton(ButtonType.OK);
        btOk.setText(Texts.getText("yes", new Object[0]));
        Button btCancel = (Button)alert.getDialogPane().lookupButton(ButtonType.CANCEL);
        btCancel.setText(Texts.getText("no", new Object[0]));
        Optional result = alert.showAndWait();
        return result.orElse(ButtonType.NO);
    }

    public static void showConfirmMesg(StackPane pane, String text) {
    }

    public static ButtonType showInfoMsg(Stage stage, String header) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.initStyle(StageStyle.UNDECORATED);
        alert.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
        alert.initOwner((Window)stage);
        alert.setHeaderText(header);
        Button btOk = (Button)alert.getDialogPane().lookupButton(ButtonType.OK);
        btOk.setText(Texts.getText("accept", new Object[0]));
        Optional result = alert.showAndWait();
        return result.orElse(ButtonType.CANCEL);
    }

    public static ButtonType showErrorMsg(Stage stage, String header) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.initStyle(StageStyle.UNDECORATED);
        alert.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
        alert.initOwner((Window)stage);
        alert.setHeaderText(header);
        Button btOk = (Button)alert.getDialogPane().lookupButton(ButtonType.OK);
        btOk.setText(Texts.getText("accept", new Object[0]));
        Optional result = alert.showAndWait();
        return result.orElse(ButtonType.CANCEL);
    }

    public static Optional<String> showChoiceMsg(Stage stage, String header, List<String> choices, int select) {
        ChoiceDialog dialog = new ChoiceDialog(choices.isEmpty() || select >= choices.size() ? null : choices.get(select), choices);
        dialog.initStyle(StageStyle.UNDECORATED);
        dialog.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
        dialog.initOwner((Window)stage);
        dialog.setHeaderText(header);
        Button btOk = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
        btOk.setText(Texts.getText("accept", new Object[0]));
        Button btCancel = (Button)dialog.getDialogPane().lookupButton(ButtonType.CANCEL);
        btCancel.setText(Texts.getText("cancel", new Object[0]));
        Optional result = dialog.showAndWait();
        return result;
    }

    public static Optional<String> showInputTextMsg(Stage stage, String header, String defaultValue) {
        TextInputDialog dialog = new TextInputDialog(defaultValue);
        dialog.initStyle(StageStyle.UNDECORATED);
        dialog.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
        dialog.initOwner((Window)stage);
        dialog.setHeaderText(header);
        Button btOk = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
        btOk.setText(Texts.getText("accept", new Object[0]));
        Button btCancel = (Button)dialog.getDialogPane().lookupButton(ButtonType.CANCEL);
        btCancel.setText(Texts.getText("cancel", new Object[0]));
        Optional result = dialog.showAndWait();
        return result;
    }
}

