/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.view.controller;

import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.FileVersion;
import com.anf.autoupdate.model.DefaultProgressListener;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.autoupdate.text.Texts;
import com.anf.autoupdate.view.DefaultViewController;
import com.anf.autoupdate.view.controller.UpdateWindow;
import com.anf.autoupdate.view.model.FileUpdateItem;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListView;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateProgressController
extends DefaultProgressListener
implements UpdateWindow {
    private static final Logger log = LogManager.getLogger(UpdateProgressController.class);
    @FXML
    private StackPane stackPane;
    @FXML
    private HBox mainBox;
    @FXML
    private VBox vBox;
    @FXML
    private Label updateTitle;
    @FXML
    private ImageView icon;
    @FXML
    private Label updateFile;
    @FXML
    private ProgressIndicator progressCircle;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private JFXButton cancelButton;
    @FXML
    private JFXButton closeButton;
    @FXML
    private VBox detailsBox;
    @FXML
    private JFXButton detailsButton;
    @FXML
    private JFXListView<FileUpdateItem> fileList;
    private boolean details = true;
    UpdateParams params;
    private List<FileVersion> latestVersions;
    private AppVersion lastVersion;
    int updated = 0;
    List<FileUpdateItem> items;
    private boolean cancelRequested = false;

    public UpdateProgressController() {
        super(new DefaultViewController());
    }

    @Override
    public void init(UpdateParams params, AppVersion lastVersion, Stage stage) {
        this.params = params;
        this.lastVersion = lastVersion;
        this.showDetails(null);
        this.detailsButton.setOnAction(this::showDetails);
        this.cancelButton.setOnAction(this::cancel);
        this.closeButton.setOnAction(this::close);
        this.ensureFx(() -> {
            this.cancelButton.setText(Texts.getText("cancel", new Object[0]));
            this.updateFile.setText("");
            this.updateTitle.setText(Texts.getText("updating.app", params.getAppName(), params.getVersion(), lastVersion.getVersion()));
            this.detailsButton.setText(Texts.getText("details.show", new Object[0]));
            this.progressBar.setProgress(0.0);
        });
    }

    private void close(ActionEvent e) {
        Platform.exit();
        System.exit(0);
    }

    private void cancel(ActionEvent e) {
        log.info("cancel requested");
        this.cancelRequested = true;
        this.cancelButton.setDisable(true);
    }

    private void showDetails(ActionEvent event) {
        if (this.details) {
            this.detailsButton.setText(Texts.getText("details.show", new Object[0]));
            this.details = false;
            this.fileList.setVisible(false);
            this.fileList.setMaxHeight(0.0);
            this.fileList.setPrefHeight(0.0);
        } else {
            this.fileList.setVisible(true);
            this.fileList.setMaxHeight(200.0);
            this.fileList.setPrefHeight(200.0);
            this.detailsButton.setText(Texts.getText("details.hide", new Object[0]));
            this.details = true;
        }
    }

    @Override
    public boolean checkStop() throws InterruptedException {
        log.info("cancel requested: {}", (Object)this.cancelRequested);
        if (this.cancelRequested) {
            throw new InterruptedException();
        }
        return this.cancelRequested;
    }

    @Override
    public void onUpdateStart(List<FileVersion> latestVersions) {
        this.latestVersions = latestVersions;
        this.items = this.latestVersions.stream().map(FileUpdateItem::new).toList();
        this.ensureFx(() -> this.fileList.getItems().addAll(this.items));
    }

    @Override
    public void onUpdateFileStart(FileVersion fv) {
        super.onUpdateFileStart(fv);
        FileUpdateItem item = this.find(fv);
        if (item != null) {
            item.setDownloading();
        }
        this.ensureFx(() -> this.updateFile.setText(Texts.getText("updating.file", fv.getPath())));
    }

    @Override
    public void onUpdateFile(FileVersion appFile) {
        super.onUpdateFile(appFile);
        FileUpdateItem item = this.find(appFile);
        if (item != null) {
            item.setSuccess();
        }
        if (!this.latestVersions.isEmpty()) {
            this.ensureFx(() -> this.progressBar.setProgress((double)(++this.updated) / (double)this.latestVersions.size()));
        }
    }

    @Override
    public boolean onDeleteFileError(File appFile, FileVersion version) {
        FileUpdateItem item = this.find(version);
        if (item != null) {
            this.ensureFx(() -> item.setError("ERR_DELETE_FILE"));
        }
        return super.onDeleteFileError(appFile, version);
    }

    @Override
    public boolean onUpdateFileError(FileVersion appFile, Exception e) {
        FileUpdateItem item = this.find(appFile);
        if (item != null) {
            this.ensureFx(() -> item.setError(e.getLocalizedMessage()));
        }
        return super.onUpdateFileError(appFile, e);
    }

    @Override
    public void onBackupStart() {
        super.onBackupStart();
        this.ensureFx(() -> {
            this.progressBar.setProgress(-1.0);
            this.updateFile.setText(Texts.getText("backup.start", new Object[0]));
        });
    }

    @Override
    public void onBackupEnd() {
        super.onBackupEnd();
        this.ensureFx(() -> {
            this.progressBar.setProgress(0.0);
            this.updateFile.setText(Texts.getText("update.start", new Object[0]));
        });
    }

    @Override
    public void onRestoreStart() {
        super.onRestoreStart();
        this.ensureFx(() -> {
            this.progressBar.setProgress(-1.0);
            this.updateFile.setText(Texts.getText("restore.start", new Object[0]));
        });
    }

    @Override
    public void onRestoreEnd() {
        super.onRestoreEnd();
        this.ensureFx(() -> this.progressBar.setProgress(1.0));
    }

    @Override
    public void onUpdateSuccess(List<File> updatedFiles) {
        super.onUpdateSuccess(updatedFiles);
        this.ensureFx(() -> {
            if (updatedFiles.size() == this.latestVersions.size()) {
                this.progressBar.setProgress(1.0);
            } else if (!this.latestVersions.isEmpty()) {
                this.progressBar.setProgress((double)updatedFiles.size() / (double)this.latestVersions.size());
            }
        });
    }

    @Override
    public void onFinishEnd(boolean success) {
        super.onFinishEnd(success);
        this.cancelButton.setDisable(false);
        this.cancelButton.setOnAction(this::close);
        this.updateStatus(Texts.getText("update.finish." + (this.cancelRequested ? "cancel" : (success ? "ok" : "error")), new Object[0]));
        String title = success ? this.lastVersion.getName() + " - " + this.lastVersion.getVersion() : this.params.getAppName() + " - " + this.params.getVersion();
        this.ensureFx(() -> {
            this.updateTitle.setText(title);
            this.startCloseAnimation();
        });
    }

    private void startCloseAnimation() {
        String closeText = Texts.getText("close", new Object[0]);
        this.cancelButton.setText(closeText);
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                Thread.sleep(this.details ? 15000L : 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int i = 3;
            while (i > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int count = i--;
                this.ensureFx(() -> this.cancelButton.setText(closeText + " (" + count + ")"));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.close(null);
        });
    }

    @Override
    public void onUpdateCancel() {
        super.onUpdateCancel();
        this.ensureFx(() -> {
            this.updateTitle.setText(Texts.getText("update.cancel", new Object[0]));
            this.updateFile.setText("");
            this.startCloseAnimation();
        });
    }

    public void updateStatus(String text) {
        this.ensureFx(() -> this.updateFile.setText(text));
    }

    private void ensureFx(Runnable run) {
        if (Platform.isFxApplicationThread()) {
            run.run();
        } else {
            Platform.runLater((Runnable)run);
        }
    }

    private FileUpdateItem find(FileVersion appFile) {
        return this.items.stream().filter(i -> i.getFile() == appFile).findFirst().orElse(null);
    }
}

