/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.view;

import com.anf.autoupdate.model.MessageController;
import com.anf.autoupdate.text.Texts;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;

public class DefaultViewController
implements MessageController {
    private final ButtonType yes = new ButtonType("SI", ButtonBar.ButtonData.YES);
    private final ButtonType no = new ButtonType("NO", ButtonBar.ButtonData.NO);
    private final ButtonType ok = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
    private ExecutorService single = Executors.newSingleThreadExecutor();

    @Override
    public void showMessage(String message) {
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        this.showMessage(message, type, Texts.getText("error.title", new Object[0]), b -> {});
    }

    @Override
    public boolean showConfirmMessage(String message, Alert.AlertType type) {
        return this.showConfirmMessage(message, null, type);
    }

    @Override
    public boolean showConfirmMessage(String message, Throwable error, Alert.AlertType type) {
        if (Platform.isFxApplicationThread()) {
            return this.showConfirm(message, error, type) == this.yes;
        }
        AtomicBoolean result = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(1);
        this.single.execute(() -> Platform.runLater(() -> {
            result.set(this.showConfirm(message, error, type) == this.yes);
            latch.countDown();
        }));
        try {
            latch.await();
            return result.get();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private ButtonType showConfirm(String message, Throwable error, Alert.AlertType type) {
        String title = Texts.getText("confirm.title", new Object[0]);
        Alert alert = new Alert(type, null, new ButtonType[]{this.yes, this.no});
        alert.setTitle(title);
        if (error != null) {
            alert.setContentText(error.getLocalizedMessage());
        }
        alert.setHeaderText(message);
        return alert.showAndWait().orElse(this.no);
    }

    private void showMessage(String message, Alert.AlertType type, String title, Consumer<ButtonType> button) {
        if (Platform.isFxApplicationThread()) {
            this.show(message, type, title, button);
        } else {
            this.single.execute(() -> Platform.runLater(() -> this.show(message, type, title, button)));
        }
    }

    private void show(String message, Alert.AlertType type, String title, Consumer<ButtonType> button) {
        Optional<ButtonType> result = this.getAlertResult(message, type, title);
        button.accept(result.orElse(null));
    }

    private Optional<ButtonType> getAlertResult(String message, Alert.AlertType type, String title) {
        Alert alert = new Alert(type, null, new ButtonType[]{this.ok});
        alert.setTitle(title);
        alert.setHeaderText(message);
        return alert.showAndWait();
    }

    @Override
    public void showErrorMessage(String message, Throwable error) {
        Alert.AlertType type = Alert.AlertType.ERROR;
        String title = "Error";
        this.showMessage(message, type, title, b -> {});
    }
}

