/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandExecService {
    private static final Logger log = LogManager.getLogger(CommandExecService.class);

    public static String executeCmd(String command) throws InterruptedException, IOException {
        log.info("ejecutando: {}", (Object)command);
        Process proc = new ProcessBuilder(new String[0]).redirectErrorStream(true).command("cmd.exe", "/C", command).start();
        return CommandExecService.execute(proc);
    }

    public static String execute(String ... command) throws InterruptedException, IOException {
        log.info("ejecutando: {}", (Object)String.join((CharSequence)" ", command));
        Process proc = new ProcessBuilder(new String[0]).redirectErrorStream(true).command(command).start();
        return CommandExecService.execute(proc);
    }

    public static String execute(Process proc) throws InterruptedException, IOException {
        boolean waitFor = proc.waitFor(30L, TimeUnit.SECONDS);
        if (!waitFor) {
            log.info("el comando no ha terminado de ejecutarse");
        }
        int exitValue = proc.exitValue();
        log.info("exit value " + exitValue);
        InputStream in = proc.getInputStream();
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("850")));){
            sb.append(reader.readLine()).append("\n");
        }
        String out = sb.toString();
        log.info("salida:\n" + out);
        return out;
    }

    public static void executeMultipleCommands(String[] commands) throws InterruptedException, IOException {
        for (String command : commands) {
            CommandExecService.executeCmd(command);
        }
    }

    public static void executeMultipleCommands(List<String> commands) throws InterruptedException, IOException {
        for (String command : commands) {
            CommandExecService.executeCmd(command);
        }
    }
}

