/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateRegistryVersion {
    private static final Logger log = LogManager.getLogger(UpdateRegistryVersion.class);
    private static String[] uninstallKeys = new String[]{"SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"};

    public static boolean updateVersion(String appName, String version) {
        log.info("intentando actualizar la version de {} en el registro con la version {}", (Object)appName, (Object)version);
        try {
            for (String uninstallKey : uninstallKeys) {
                String[] subKeys;
                for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)uninstallKey)) {
                    String appKey = uninstallKey + "\\" + subKey;
                    String displayName = null;
                    try {
                        displayName = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)appKey, (String)"DisplayName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (displayName == null || !displayName.equals(appName)) continue;
                    String displayVersion = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)appKey, (String)"DisplayVersion");
                    log.info("CLSID: {}", (Object)subKey);
                    log.info("DisplayName: {}", (Object)displayName);
                    log.info("DisplayVersion: {}", (Object)displayVersion);
                    Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)appKey, (String)"DisplayVersion", (String)version);
                    log.info("DisplayVersion changed to {} for CLSID: {}", (Object)version, (Object)subKey);
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("error intentando actualizar la version en el registro", (Throwable)e);
        }
        return false;
    }
}

