/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.model;

import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.FileVersion;
import com.anf.autoupdate.model.UpdateProgressListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

public class UpdateParams {
    private String appId;
    private String appName;
    private String version;
    private File dir;
    private File tmpDir;
    private File configFile;
    private boolean backup = true;
    private UpdateProgressListener listener;
    private String[] ignored;
    private List<String> stopCommands;
    private List<String> startCommands;
    private List<String> restartRequiredFilters;
    private String serviceUrl;
    private int serviceTimeout = 30000;
    private Properties conf;

    public UpdateParams(Properties conf) {
        this.conf = conf;
    }

    public Properties getConf() {
        return this.conf;
    }

    public int getServiceTimeout() {
        return this.serviceTimeout;
    }

    public void setServiceTimeout(int serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public List<String> getStopCommands() {
        return this.stopCommands;
    }

    public void setStopCommands(List<String> stopCommands) {
        this.stopCommands = stopCommands;
    }

    public List<String> getStartCommands() {
        return this.startCommands;
    }

    public void setStartCommands(List<String> startCommands) {
        this.startCommands = startCommands;
    }

    public List<String> getRestartRequiredFilters() {
        return this.restartRequiredFilters;
    }

    public void setRestartRequiredFilters(List<String> restartRequiredFilters) {
        this.restartRequiredFilters = restartRequiredFilters;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public UpdateProgressListener getListener() {
        return this.listener;
    }

    public void setListener(UpdateProgressListener listener) {
        this.listener = listener;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public File getTmpDir() {
        if (this.tmpDir != null) {
            this.tmpDir.mkdirs();
        }
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public File backupDir() {
        File backupDir = new File(this.getTmpDir(), "backup");
        backupDir.mkdirs();
        return backupDir;
    }

    public boolean onDeleteFileError(File appFile, FileVersion version) {
        if (this.listener != null) {
            return this.listener.onDeleteFileError(appFile, version);
        }
        throw new RuntimeException("ERR_FILE_DELETE:" + appFile);
    }

    public boolean onUpdateFileError(FileVersion fv, Exception e) {
        if (this.listener != null) {
            return this.listener.onUpdateFileError(fv, e);
        }
        throw new RuntimeException("ERR_UPDATE_DELETE:" + fv, e);
    }

    public boolean onUpdateFilesError(Exception e) {
        if (this.listener != null) {
            return this.listener.onUpdateFilesError(e);
        }
        throw new RuntimeException("ERR_UPDATE_FILES", e);
    }

    public boolean onRestoreFileError(File appFile, Exception e) {
        if (this.listener != null) {
            return this.listener.onRestoreFileError(appFile, e);
        }
        throw new RuntimeException("ERR_RESTORE_FILE:" + appFile, e);
    }

    public boolean onRestoreFilesError(Exception e) {
        if (this.listener != null) {
            return this.listener.onRestoreFilesError(e);
        }
        throw new RuntimeException("ERR_RESTORE_FILES", e);
    }

    public void onUpdateFile(FileVersion fv) {
        if (this.listener != null) {
            this.listener.onUpdateFile(fv);
        }
    }

    public void onUpdateStart(List<FileVersion> latestVersions) {
        if (this.listener != null) {
            this.listener.onUpdateStart(latestVersions);
        }
    }

    public void onUpdateSuccess(List<File> updatedFiles) {
        if (this.listener != null) {
            this.listener.onUpdateSuccess(updatedFiles);
        }
    }

    public void onUpdateFileStart(FileVersion fv) {
        if (this.listener != null) {
            this.listener.onUpdateFileStart(fv);
        }
    }

    public void setIgnored(String[] ignored) {
        this.ignored = ignored;
    }

    public String[] getIgnored() {
        return this.ignored;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void updateConfigFile(AppVersion app) throws IOException {
        Properties conf = new Properties();
        conf.setProperty("app.id", app.getAppId());
        conf.setProperty("app.name", app.getName());
        conf.setProperty("app.version", app.getVersion());
        conf.setProperty("next.update", "always");
        this.updateConfigFile(conf);
    }

    public void updateConfigFile(List<String> ignored) throws IOException {
        Properties conf = new Properties();
        conf.setProperty("ignore.files", String.join((CharSequence)",", ignored));
        this.updateConfigFile(conf);
    }

    public void updateConfigFile(Properties conf) throws IOException {
        if (this.configFile.exists()) {
            List<Object> lines = new ArrayList();
            TreeSet added = new TreeSet();
            try (FileReader reader = new FileReader(this.configFile);
                 BufferedReader read = new BufferedReader(reader);){
                lines = read.lines().map(line -> {
                    String key;
                    String value;
                    int index = ((String)(line = ((String)line).trim())).indexOf("=");
                    if (index > 0 && (value = conf.getProperty(key = ((String)line).substring(0, index).trim())) != null) {
                        line = key + "=" + value;
                        added.add(key);
                    }
                    return line;
                }).toList();
            }
            List<String> notListed = conf.keySet().stream().filter(key -> !added.contains(key)).map(key -> {
                String value = conf.getProperty(key.toString());
                if (value != null) {
                    return key + "=" + value;
                }
                return "";
            }).filter(line -> !line.isEmpty()).toList();
            lines = new ArrayList(lines);
            if (!notListed.isEmpty()) {
                lines.addAll(notListed);
            }
            if (!lines.isEmpty()) {
                Collections.sort(lines);
                try (FileWriter writer = new FileWriter(this.configFile);){
                    for (String string : lines) {
                        writer.append(string + "\n");
                    }
                }
            }
        }
    }

    public String getServiceUrl(String defaultValue) {
        if (this.serviceUrl == null) {
            this.serviceUrl = defaultValue;
        }
        return this.serviceUrl;
    }
}

