/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.client.model;

import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.FileAction;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;

public class FileVersion
implements Comparable<FileVersion> {
    private Long id;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="UTC")
    private Date created;
    private String path;
    private AppVersion app;
    private String hash;
    private long size;
    private FileAction action;
    @JsonIgnore
    private boolean updated = false;
    @JsonIgnore
    private Exception error;

    public FileVersion() {
    }

    public FileVersion(String path, AppVersion app, String hash, long size, FileAction action) {
        this.path = path;
        this.app = app;
        this.hash = hash;
        this.size = size;
        this.action = action;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AppVersion getApp() {
        return this.app;
    }

    public void setApp(AppVersion app) {
        this.app = app;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        return this.path + " " + this.app.getName() + "-" + this.app.getVersion() + " " + this.action.name();
    }

    public FileAction getAction() {
        return this.action;
    }

    public void setAction(FileAction action) {
        this.action = action;
    }

    @Override
    public int compareTo(FileVersion other) {
        return this.app.compareTo(other.app);
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }
}

