/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.client;

import com.anf.autoupdate.client.model.AppVersion;
import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.client.params.OauthParams;
import com.anf.oauth.json.JSONFactory;
import java.io.IOException;

public class LastAppVersionClient
extends AbstractClient {
    public LastAppVersionClient(String url, long timeout) {
        super(url, timeout);
    }

    public LastAppVersionClient(String url, long timeout, OauthParams oauthParams) {
        super(url, timeout, oauthParams);
    }

    public AppVersion lastVersion(String appId) throws IOException {
        String uri = "/api/client/last-version?appid=" + appId;
        String token = System.getenv("AUTOUPDATE_TOKEN");
        if (token != null) {
            uri = uri + "&token=" + token;
        }
        return this.getLastVersion(uri);
    }

    public AppVersion lastVersionAdmin(String appId) throws IOException {
        String uri = "/api/admin/last-version?appid=" + appId;
        return this.getLastVersion(uri);
    }

    private AppVersion getLastVersion(String uri) throws IOException {
        byte[] resp = null;
        try {
            resp = this.handleRawRequest(uri, "POST", "application/json", null);
        }
        catch (IOException e) {
            throw new IOException("APP_VERSION_NOT_FOUND");
        }
        if (resp == null) {
            throw new IOException("APP_VERSION_NOT_FOUND");
        }
        return (AppVersion)JSONFactory.buildObject((byte[])resp, AppVersion.class);
    }
}

