/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.client;

import com.anf.autoupdate.client.DownloadFileVersionClient;
import com.anf.autoupdate.client.LastAppVersionClient;
import com.anf.autoupdate.client.LatestVersionsClient;
import com.anf.oauth.client.params.OauthParams;

public class ClientFactory {
    private DownloadFileVersionClient downloadFileClient;
    private LatestVersionsClient latestVersionClient;
    private LastAppVersionClient lastVersionClient;

    public ClientFactory(String url, int timeout) {
        this.latestVersionClient = new LatestVersionsClient(url, timeout);
        this.downloadFileClient = new DownloadFileVersionClient(url, timeout);
        this.lastVersionClient = new LastAppVersionClient(url, timeout);
    }

    public ClientFactory(String url, int timeout, OauthParams oauthParams) {
        this.latestVersionClient = new LatestVersionsClient(url, timeout, oauthParams);
        this.downloadFileClient = new DownloadFileVersionClient(url, timeout, oauthParams);
        this.lastVersionClient = new LastAppVersionClient(url, timeout, oauthParams);
    }

    public LastAppVersionClient getLastVersionClient() {
        return this.lastVersionClient;
    }

    public DownloadFileVersionClient getDownloadFileClient() {
        return this.downloadFileClient;
    }

    public LatestVersionsClient getLatestVersionClient() {
        return this.latestVersionClient;
    }
}

