/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.model.UpdateParams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface UpdateParamsFactory {
    public static final Logger log = LogManager.getLogger(UpdateParamsFactory.class);
    public static final File updateTmpDir = new File(System.getProperty("java.io.tmpdir"), "autoupdate");

    public static UpdateParams fromConfigFile(File configFile) throws IOException {
        if (configFile.exists() && configFile.isDirectory()) {
            configFile = new File(configFile, "update.cfg");
        }
        if (!configFile.exists()) {
            throw new FileNotFoundException("config file no existe: " + configFile);
        }
        Properties conf = UpdateParamsFactory.load(configFile);
        UpdateParams params = new UpdateParams(conf);
        params.setConfigFile(configFile.getCanonicalFile());
        boolean newAppId = false;
        String appId = conf.getProperty("app.id");
        if (appId == null || appId.isEmpty()) {
            appId = UUID.randomUUID().toString();
            newAppId = true;
        }
        params.setAppId(appId);
        params.setServiceUrl(conf.getProperty("service.url"));
        try {
            params.setServiceTimeout(Integer.parseInt(conf.getProperty("service.timeout")));
        }
        catch (NumberFormatException e) {
            params.setServiceTimeout(30000);
        }
        String appName = conf.getProperty("app.name");
        if (appName == null) {
            throw new RuntimeException("ERR_NO_APP_NAME");
        }
        params.setAppName(appName);
        String appVersion = conf.getProperty("app.version");
        if (appVersion == null) {
            throw new RuntimeException("ERR_NO_APP_VERSION");
        }
        params.setVersion(appVersion);
        params.setDir(configFile.getParentFile().getCanonicalFile());
        params.setTmpDir(new File(new File(updateTmpDir, appName + " - " + appVersion), UUID.randomUUID().toString()));
        params.setBackup(Boolean.valueOf(conf.getProperty("backup", "true")));
        String ignored = conf.getProperty("ignore.files", "update.cfg,logs/**");
        params.setIgnored(ignored.split(","));
        if (newAppId) {
            params.updateConfigFile(new AppVersion(appId, appName, appVersion, "", true));
        }
        return params;
    }

    public static Properties load(File configFile) throws IOException {
        Properties conf = new Properties();
        try (FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);){
            conf.load(reader);
        }
        return conf;
    }

    public static void updateConfigFile(File configFile, Properties conf) throws IOException {
        Properties current = UpdateParamsFactory.load(configFile);
        conf.keySet().forEach(key -> {
            String value = conf.getProperty(key.toString());
            if (value != null) {
                current.setProperty(key.toString(), value);
            }
        });
        UpdateParamsFactory.save(configFile, current);
    }

    public static void newConfigFile(String url, AppVersion app, File configFile) throws IOException {
        Properties conf = new Properties();
        conf.setProperty("app.id", app.getAppId());
        conf.setProperty("app.name", app.getName());
        conf.setProperty("app.version", app.getVersion());
        conf.setProperty("backup", "true");
        conf.setProperty("ignore.files", "update.cfg,logs/**");
        conf.setProperty("service.url", url);
        conf.setProperty("service.timeout", "30000");
        UpdateParams params = new UpdateParams(conf);
        params.setConfigFile(configFile.getCanonicalFile());
        UpdateParamsFactory.save(configFile, conf);
    }

    public static void save(File configFile, Properties conf) throws IOException {
        try (FileWriter writer = new FileWriter(configFile, StandardCharsets.UTF_8);){
            conf.store(writer, null);
        }
    }
}

