/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.AutoupdateConfigurer;
import com.anf.autoupdate.client.model.NormalizeVersion;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.autoupdate.model.UpdateProgressListener;
import com.anf.autoupdate.services.ChekFileWriteService;
import com.anf.autoupdate.text.Texts;
import com.anf.autoupdate.view.controller.UpdateProgressController;
import com.anf.autoupdate.view.controller.UpdateVersionController;
import com.anf.autoupdate.view.controller.UpdateWindow;
import com.anf.autoupdate.view.messages.MessageUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoupdateVisualApplication
extends Application {
    private static final int WINDOW_HEIGHT = 350;
    private static final int WINDOW_WIDTH = 500;
    private static final Logger log = LogManager.getLogger(AutoupdateVisualApplication.class);
    private double xOffset;
    private double yOffset;
    private static final Background TRANSPARENT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)});
    private ExecutorService async = Executors.newSingleThreadExecutor();
    private Stage primary;
    private AutoupdateConfigurer configurer;

    public void init() throws Exception {
        super.init();
        Application.Parameters parameters = this.getParameters();
        if (parameters == null || parameters.getRaw() == null || parameters.getRaw().isEmpty()) {
            System.out.println("se debe ejecutar pasando: [update <path>] donde path es la ruta del archivo de configuracion dentro de la carpeta a actualizar");
            throw new Exception("ERR_NO_PARAMETERS");
        }
        this.configurer = new AutoupdateConfigurer((String)parameters.getRaw().get(1));
    }

    public void start(Stage primary) throws Exception {
        this.primary = primary;
        primary.setOpacity(0.0);
        if (NormalizeVersion.validate(this.configurer.getLastVersion().getVersion(), this.configurer.getParams().getVersion())) {
            this.showNewVersionWindow();
        } else {
            this.showNoUpdate();
        }
    }

    private void showNoUpdate() {
        Stage stage = this.showInvisibleStage();
        MessageUtils.showInfoMsg(stage, Texts.getText("no.update", this.configurer.getLastVersion().getName(), this.configurer.getLastVersion().getVersion()));
    }

    private Stage showInvisibleStage() {
        Scene scene = new Scene((Parent)new AnchorPane());
        scene.setFill((Paint)Color.TRANSPARENT);
        Stage stage = this.defaultStage(scene);
        stage.setOpacity(0.0);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.setWidth(1.0);
        stage.setHeight(1.0);
        stage.setScene(scene);
        stage.centerOnScreen();
        stage.show();
        return stage;
    }

    private void showNewVersionWindow() throws IOException {
        File dir = this.configurer.getParams().getConfigFile().getParentFile();
        if (!ChekFileWriteService.checkWritePermission(dir)) {
            log.info("notificando error de escritura");
            Stage stage = this.showInvisibleStage();
            MessageUtils.showErrorMsg(stage, Texts.getText("write.error", new Object[0]));
            log.info("saliendo del autoupdate por error de escritura");
            Platform.exit();
            System.exit(0);
        }
        this.showView("newversion.fxml", UpdateVersionController.class, c -> {
            Platform.runLater(() -> c.setFileVersions(this.configurer.getLatestVersions()));
            c.setOnUpdate(this::update);
        }, windowStage -> {
            windowStage.initModality(Modality.APPLICATION_MODAL);
            windowStage.setResizable(false);
        });
    }

    private void update() {
        try {
            UpdateParams params = this.configurer.getParams();
            this.showView("update.fxml", UpdateProgressController.class, c -> {
                params.setListener((UpdateProgressListener)c);
                try {
                    params.getListener().onUpdateStart(this.configurer.getLatestVersions());
                    this.configurer.getUpdateController().update(this.configurer.getLatestVersions());
                }
                catch (Exception e1) {
                    log.catching((Throwable)e1);
                }
            }, windowStage -> windowStage.initStyle(StageStyle.TRANSPARENT));
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    private void setOnBottomRightCorner(Stage stage) {
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        stage.setX(primaryScreenBounds.getWidth() - 500.0);
        stage.setY(primaryScreenBounds.getHeight() - 350.0);
    }

    private <T extends UpdateWindow> Stage showView(String fxml, Class<T> clazz, Consumer<T> op, Consumer<Stage> stageEdit) throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(Thread.currentThread().getContextClassLoader().getResource(fxml));
        StackPane root = (StackPane)loader.load();
        UpdateWindow controller = (UpdateWindow)loader.getController();
        Scene scene = new Scene((Parent)root);
        scene.setFill((Paint)Color.TRANSPARENT);
        root.setBackground(TRANSPARENT_BACKGROUND);
        root.applyCss();
        Stage windowStage = this.defaultStage(scene);
        if (stageEdit != null) {
            stageEdit.accept(windowStage);
        }
        controller.init(this.configurer.getParams(), this.configurer.getLastVersion(), windowStage);
        if (op != null) {
            this.async.execute(() -> op.accept(controller));
        }
        windowStage.show();
        return windowStage;
    }

    private Stage defaultStage(Scene scene) {
        Stage windowStage = new Stage();
        windowStage.initOwner((Window)this.primary);
        windowStage.setScene(scene);
        windowStage.setOpacity(1.0);
        windowStage.setAlwaysOnTop(true);
        windowStage.setWidth(500.0);
        windowStage.setHeight(350.0);
        this.setOnBottomRightCorner(windowStage);
        windowStage.setTitle(this.configurer.getParams().getAppName());
        windowStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/anflogo.png"), 32.0, 32.0, true, true));
        windowStage.setOnCloseRequest(e -> System.exit(0));
        ReadOnlyObjectProperty sceneChaged = windowStage.sceneProperty();
        InvalidationListener mouseDragListener = sceneListener -> {
            scene.setOnMousePressed(event -> {
                this.xOffset = windowStage.getX() - event.getScreenX();
                this.yOffset = windowStage.getY() - event.getScreenY();
            });
            scene.setOnMouseDragged(event -> {
                windowStage.setX(event.getScreenX() + this.xOffset);
                windowStage.setY(event.getScreenY() + this.yOffset);
            });
            new Thread(() -> Platform.runLater(() -> {
                windowStage.setOpacity(1.0);
                windowStage.setMinWidth(scene.getWidth());
                windowStage.setMinHeight(scene.getHeight());
            })).start();
            System.out.println("scene loaded");
        };
        sceneChaged.addListener(mouseDragListener);
        return windowStage;
    }
}

