/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.services.CommandExecService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoupdateCopy {
    private static final Logger log = LogManager.getLogger(AutoupdateCopy.class);

    public static void launch(String path) {
        try {
            File exeTmp = AutoupdateCopy.copy(path, true);
            boolean exec = false;
            if (exec && exeTmp != null) {
                CharSequence[] command = new String[]{"\"" + exeTmp.getCanonicalPath() + "\"", "update", "\"" + path + "\""};
                log.info("ejecutado comando: {}", (Object)String.join((CharSequence)" ", command));
                File bat = new File(exeTmp.getParentFile(), "start.bat");
                File errFile = new File("C:\\autoupdate\\error.txt");
                try (FileWriter writer = new FileWriter(bat, StandardCharsets.UTF_8);){
                    writer.write(String.join((CharSequence)" ", command) + " > " + errFile.getCanonicalPath() + "\n");
                    writer.flush();
                }
                if (bat.exists()) {
                    errFile.getParentFile().mkdirs();
                    Process proc = new ProcessBuilder("cmd", "/c", "start", "\"\"", "\"" + bat.getCanonicalPath() + "\"").directory(exeTmp.getParentFile()).start();
                    log.info("proceso ejecutado: {}", (Object)proc.pid());
                    int exitCode = proc.waitFor();
                    log.info("exit code: {}", (Object)exitCode);
                } else {
                    log.warn("el archivo no existe: {}", (Object)bat);
                }
                log.info("esperando 5 segundos para terminar el proceso de copia temporal");
                TimeUnit.SECONDS.sleep(5L);
                log.info("se termina el proceso de copia temporal");
            }
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static File copy(String path, boolean copyExe) throws IOException, InterruptedException {
        File lib;
        File tmp = new File(System.getProperty("java.io.tmpdir"), "autoupdate");
        String appName = new File(path).getName();
        if (!(tmp = new File(tmp, appName)).exists()) {
            tmp.mkdirs();
        } else {
            String copyCommand = "rd /Q /S \"" + tmp.getCanonicalPath() + "\"";
            log.info("eliminando carpeta temporal del autoupdate: {}", (Object)copyCommand);
            String result = CommandExecService.executeCmd(copyCommand);
            log.info("result:{}", (Object)result);
        }
        File jre = new File(path, "jre");
        if (jre.exists()) {
            String copyCommand = "xcopy \"" + jre.getCanonicalPath() + "\\*.*\" \"" + tmp.getCanonicalPath() + "\\jre\\\" /S /Q /Y";
            log.info("copiando carpeta del JRE: {}", (Object)copyCommand);
            String result = CommandExecService.executeCmd(copyCommand);
            log.info("result:{}", (Object)result);
        }
        if ((lib = new File(path, "lib")).exists()) {
            String copyCommand = "xcopy \"" + lib.getCanonicalPath() + "\\*.jar\" \"" + tmp.getCanonicalPath() + "\\lib\\\" /S /Q /Y";
            log.info("copiando carpeta lib: {}", (Object)copyCommand);
            String result = CommandExecService.executeCmd(copyCommand);
            log.info("result:{}", (Object)result);
        }
        if (copyExe) {
            File exe = new File(path, "anf-update.exe");
            File exeTmp = new File(tmp, "anf-update.exe");
            if (exe.exists()) {
                String copyCommand = "copy /V /Y \"" + exe.getCanonicalPath() + "\" \"" + exeTmp.getCanonicalPath();
                log.info("copiando ejecutable: {}", (Object)copyCommand);
                String result = CommandExecService.executeCmd(copyCommand);
                log.info("result:{}", (Object)result);
            }
            return exeTmp;
        }
        return null;
    }
}

