/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.AutoupdateController;
import com.anf.autoupdate.UpdateParamsFactory;
import com.anf.autoupdate.client.ClientFactory;
import com.anf.autoupdate.client.DownloadFileVersionClient;
import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.FileVersion;
import com.anf.autoupdate.model.AppConfigJson;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.oauth.json.JSONFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoupdateConfigurer {
    private static final Logger log = LogManager.getLogger(AutoupdateConfigurer.class);
    private AutoupdateController updateController;
    private UpdateParams params;
    private AppVersion lastVersion;
    private List<FileVersion> latestVersions;

    public AutoupdateConfigurer(String configPath) throws IOException {
        String jsonConfig;
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            throw new FileNotFoundException("el archivo de config no existe: " + configFile);
        }
        this.params = UpdateParamsFactory.fromConfigFile(configFile);
        String url = this.params.getServiceUrl("http://localhost:8000");
        int timeout = this.params.getServiceTimeout();
        ClientFactory clientFactory = new ClientFactory(url, timeout);
        if (this.params.getAppId() == null) {
            log.warn("app.id not found in file {}/update.cfg", (Object)configFile);
        }
        this.lastVersion = clientFactory.getLastVersionClient().lastVersion(this.params.getAppId());
        if (this.lastVersion == null || this.lastVersion.getAppId() == null) {
            log.warn("last version of app {} not found", (Object)this.params.getAppId());
            Platform.exit();
            System.exit(0);
        }
        this.latestVersions = clientFactory.getLatestVersionClient().latestVersions(this.params.getAppId(), this.params.getVersion());
        if (this.latestVersions != null) {
            log.info("number of files to update: {}", (Object)this.latestVersions.size());
            for (FileVersion fv : this.latestVersions) {
                log.info("file to update: {} app: {}", (Object)fv.getPath(), (Object)fv.getApp());
            }
        }
        if ((jsonConfig = this.lastVersion.getConfig()) != null) {
            log.info("config:\n{}", (Object)jsonConfig);
            AppConfigJson config = (AppConfigJson)JSONFactory.buildObject((String)jsonConfig, (String)"config", AppConfigJson.class);
            if (config.getRestartFilters() != null && !config.getRestartFilters().isEmpty()) {
                this.params.setRestartRequiredFilters(config.getRestartFilters());
            }
            if (config.getStopCommands() != null && !config.getStopCommands().isEmpty()) {
                this.params.setStopCommands(config.getStopCommands());
            }
            if (config.getStartCommands() != null && !config.getStartCommands().isEmpty()) {
                this.params.setStartCommands(config.getStartCommands());
            }
        }
        DownloadFileVersionClient downloadFileClient = clientFactory.getDownloadFileClient();
        this.updateController = new AutoupdateController(downloadFileClient, this.params);
    }

    public AutoupdateController getUpdateController() {
        return this.updateController;
    }

    public void setUpdateController(AutoupdateController updateController) {
        this.updateController = updateController;
    }

    public UpdateParams getParams() {
        return this.params;
    }

    public void setParams(UpdateParams params) {
        this.params = params;
    }

    public AppVersion getLastVersion() {
        return this.lastVersion;
    }

    public void setLastVersion(AppVersion lastVersion) {
        this.lastVersion = lastVersion;
    }

    public List<FileVersion> getLatestVersions() {
        return this.latestVersions;
    }

    public void setLatestVersions(List<FileVersion> latestVersions) {
        this.latestVersions = latestVersions;
    }
}

