/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.AutoupdateConfigurer;
import com.anf.autoupdate.client.model.NormalizeVersion;
import com.anf.autoupdate.model.DefaultProgressListener;
import com.anf.autoupdate.model.LoggerMessageController;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.autoupdate.services.ChekFileWriteService;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoupdateCmdApplication {
    private static final Logger log = LogManager.getLogger(AutoupdateCmdApplication.class);
    private AutoupdateConfigurer configurer;

    public AutoupdateCmdApplication(String[] args) {
        try {
            this.configurer = new AutoupdateConfigurer(args[1]);
        }
        catch (Exception e) {
            log.error("update config error", (Throwable)e);
            System.exit(-1);
        }
    }

    public void execute() {
        if (NormalizeVersion.validate(this.configurer.getLastVersion().getVersion(), this.configurer.getParams().getVersion())) {
            this.update();
        } else {
            log.info("there is no updates available");
            System.exit(2);
        }
    }

    private void update() {
        File dir = this.configurer.getParams().getConfigFile().getParentFile();
        if (!ChekFileWriteService.checkWritePermission(dir)) {
            System.exit(3);
        }
        UpdateParams params = this.configurer.getParams();
        params.setListener(new DefaultProgressListener(new LoggerMessageController()));
        params.getListener().onUpdateStart(this.configurer.getLatestVersions());
        try {
            this.configurer.getUpdateController().update(this.configurer.getLatestVersions());
        }
        catch (Exception e) {
            log.error("update error", (Throwable)e);
            System.exit(-1);
        }
    }
}

