/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.UpdateParamsFactory;
import com.anf.autoupdate.client.ClientFactory;
import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.NormalizeVersion;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.autoupdate.services.NextUpdateValidator;
import com.anf.trust.certs.TrustFactory;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoupdateCheck {
    private static final Logger log = LogManager.getLogger(AutoupdateCheck.class);

    public static void checkUpdate(File path, String[] args) {
        try {
            new TrustFactory(true).configureTLS();
            UpdateParams params = UpdateParamsFactory.fromConfigFile(path);
            String url = params.getServiceUrl("http://localhost:8000");
            int timeout = params.getServiceTimeout();
            ClientFactory clientFactory = new ClientFactory(url, timeout);
            AppVersion lastVersion = clientFactory.getLastVersionClient().lastVersion(params.getAppId());
            if (lastVersion == null || lastVersion.getAppId() == null) {
                log.warn("last version of app {} not found", (Object)params.getAppId());
                System.exit(1);
            }
            log.info("last app version: {} and current: {}", (Object)lastVersion, (Object)params.getVersion());
            List<String> argList = Arrays.asList(args);
            NextUpdateValidator.validateNextUpdate(params, lastVersion, argList.contains("force"), argList.contains("init"));
            if (NormalizeVersion.validate(lastVersion.getVersion(), params.getVersion())) {
                log.info("hay una nueva version disponible");
                System.exit(0);
            } else {
                log.info("la app esta actualizada");
                System.exit(2);
            }
        }
        catch (Throwable e) {
            log.error("error checkUpdate", e);
            System.exit(-1);
        }
    }
}

