/*
 * Decompiled with CFR 0.152.
 */
package anf.centralizados.client.client.impl.v2;

import anf.centralizados.client.client.error.CentralClientError;
import anf.centralizados.client.client.impl.v2.CentralClientGenericV2Impl;
import anf.centralizados.core.json.response.ResponseBoolean;
import anf.centralizados.core.json.response.impl.ResponseBooleanImpl;
import anf.centralizados.core.json.response.impl.ResponseRequestSessionImpl;
import com.anf.centralizados.error.NullTokenException;
import java.io.ByteArrayOutputStream;
import java.util.TreeMap;

public class CentralClientPassV2Impl
extends CentralClientGenericV2Impl {
    private String pass;

    public CentralClientPassV2Impl(String userId, String pass, String host, int port) {
        super(userId, host, port);
        this.pass = pass;
        this.initCache();
    }

    public CentralClientPassV2Impl(String userId, String pass, String url) {
        super(userId, url);
        this.pass = pass;
        this.initCache();
    }

    @Override
    protected void requestToken(boolean force) {
        if (this.token != null && !force) {
            return;
        }
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("pass", this.pass);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", "UNKNOW_ERROR");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ResponseRequestSessionImpl response = null;
        int responseCode = this.executeDirect("/centralizados/v2/request-session/", null, headersIn, output, headersOut);
        response = responseCode == 200 ? new ResponseRequestSessionImpl(new String(output.toByteArray()), true, null) : new ResponseRequestSessionImpl(null, false, (String)headersOut.get("errorId"));
        if (!response.isSuccess() || response.getResult() == null) {
            throw new NullTokenException();
        }
        this.token = response.getResult();
    }

    @Override
    public void login() {
        ResponseBoolean response = this.existeUsuario();
        if (!response.isSuccess()) {
            throw new CentralClientError("Ha ocurrido un error en la comunicaci\u00f3n con el servidor de certificados centralizados.");
        }
        if (!response.isResult()) {
            throw new CentralClientError("No existe el usuario.");
        }
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("pass", this.pass);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", "UNKNOW_ERROR");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int responseCode = this.executeDirect("/centralizados/v2/login/", null, headersIn, output, headersOut);
        response = responseCode == 200 ? new ResponseBooleanImpl(true, true, null) : new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
        if (!response.isSuccess() || !response.isResult()) {
            throw new CentralClientError("No se han podido verificar las credenciales del usuario.");
        }
    }

    protected void setPass(String pass) {
        this.pass = pass;
    }
}

