/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation.timestamp;

import eu.europa.esig.dss.asic.cades.validation.scope.ASiCWithCAdESTimestampScopeFinder;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampAnalyzer;
import java.util.List;

public class ASiCWithCAdESTimestampAnalyzer
extends DetachedTimestampAnalyzer {
    private List<DSSDocument> originalDocuments;
    private List<DSSDocument> archiveDocuments;
    private ArchiveTimestampType archiveTimestampType;

    public ASiCWithCAdESTimestampAnalyzer(DSSDocument timestamp) {
        super(timestamp);
    }

    public ASiCWithCAdESTimestampAnalyzer(DSSDocument timestamp, TimestampType type) {
        super(timestamp, type);
    }

    public ManifestFile getCoveredManifest() {
        return this.manifestFile;
    }

    public void setOriginalDocuments(List<DSSDocument> originalDocuments) {
        this.originalDocuments = originalDocuments;
    }

    public void setArchiveDocuments(List<DSSDocument> archiveDocuments) {
        this.archiveDocuments = archiveDocuments;
    }

    public void setArchiveTimestampType(ArchiveTimestampType archiveTimestampType) {
        this.archiveTimestampType = archiveTimestampType;
    }

    protected TimestampToken createTimestampToken() {
        TimestampToken timestamp = super.createTimestampToken();
        if (this.manifestFile != null) {
            timestamp.setManifestFile(this.manifestFile);
        }
        if (this.archiveTimestampType != null) {
            timestamp.setArchiveTimestampType(this.archiveTimestampType);
        }
        return timestamp;
    }

    protected boolean isTimestampCoveredByEvidenceRecord(TimestampToken timestampToken, EvidenceRecord evidenceRecord) {
        ManifestFile erManifestFile = evidenceRecord.getManifestFile();
        if (erManifestFile == null) {
            return true;
        }
        for (ManifestEntry entry : erManifestFile.getEntries()) {
            if (timestampToken.getFilename() == null || !timestampToken.getFilename().equals(entry.getUri())) continue;
            return true;
        }
        return false;
    }

    protected List<SignatureScope> getTimestampScopes(TimestampToken timestampToken) {
        ASiCWithCAdESTimestampScopeFinder timestampScopeFinder = new ASiCWithCAdESTimestampScopeFinder();
        timestampScopeFinder.setContainerDocuments(this.originalDocuments);
        timestampScopeFinder.setArchiveDocuments(this.archiveDocuments);
        timestampScopeFinder.setTimestampedData(this.getTimestampedData());
        return timestampScopeFinder.findTimestampScope(timestampToken);
    }

    protected boolean addReference(SignatureScope signatureScope) {
        String fileName = signatureScope.getDocumentName();
        return fileName == null || !ASiCUtils.isSignature((String)fileName) && !ASiCUtils.isTimestamp((String)fileName) && !ASiCUtils.isEvidenceRecord((String)fileName);
    }
}

