/*
 * Decompiled with CFR 0.152.
 */
package com.anf.timestamp.services;

import com.anf.timestamp.client.TSUClient;
import com.anf.timestamp.client.impl.TSAClientANF;
import com.anf.timestamp.model.URLTSU;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public final class TSUController {
    private List<URLTSU> tsus = new ArrayList<URLTSU>();
    private boolean shuffle = false;
    private static URLTSU firstToUse = null;
    private int pointer = 0;
    private static String urlAccessKey = null;

    public TSUController(String user, String pass) {
        ArrayList<URLTSU> urls = new ArrayList<URLTSU>();
        urls.add(new URLTSU("https://tsu.anf.es/TimeStampServer/TimeServer", user, pass));
        this.init(urls);
    }

    public TSUController(List<URLTSU> urls) {
        this.init(urls);
    }

    public TSUController(URLTSU ... urls) {
        if (urls != null && urls.length > 0) {
            this.init(Arrays.asList(urls));
        }
    }

    private void init(List<URLTSU> urls) {
        TreeSet<String> urlSet = new TreeSet<String>();
        for (URLTSU url : urls) {
            if (!urlSet.add(url.getUrl())) continue;
            if (urlAccessKey != null && !url.getUrl().contains("tsu5.anf.es")) {
                url.setPass(urlAccessKey);
            }
            this.tsus.add(url);
        }
        Collections.shuffle(this.tsus);
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public static void setFirstTSU(URLTSU url) {
        firstToUse = url;
    }

    public List<URLTSU> getTsus() {
        return this.tsus;
    }

    public int getTSUCount() {
        return this.tsus.size();
    }

    private TSUClient connectTSU(URLTSU url, X509Certificate[] chain) {
        if (url == null) {
            throw new IndexOutOfBoundsException("ERR_TSU_URL_NULL");
        }
        return this.getClientForURL(url, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSUClient connectNextTSU(X509Certificate[] chain) {
        TSUClient client = null;
        if (firstToUse != null) {
            client = this.connectTSU(firstToUse, chain);
        }
        int cursor = this.getPointer();
        try {
            if (client == null) {
                ArrayList<URLTSU> clone = new ArrayList<URLTSU>(this.tsus);
                if (this.shuffle) {
                    Collections.shuffle(clone);
                } else {
                    cursor %= clone.size();
                }
                while (client == null && cursor < clone.size()) {
                    client = this.connectTSU((URLTSU)clone.get(cursor), chain);
                    ++cursor;
                }
            }
        }
        finally {
            this.setPointer(cursor);
        }
        return client;
    }

    private synchronized void setPointer(int cursor) {
        this.pointer = cursor % this.tsus.size();
    }

    private synchronized int getPointer() {
        return this.pointer++;
    }

    public TSUClient getTSAClient(X509Certificate[] chain) {
        if (firstToUse != null) {
            return this.connectTSU(firstToUse, chain);
        }
        ArrayList<URLTSU> clone = new ArrayList<URLTSU>(this.tsus);
        if (this.shuffle) {
            Collections.shuffle(clone);
        }
        return this.connectTSU((URLTSU)clone.get(0), chain);
    }

    private TSUClient getClientForURL(URLTSU url, X509Certificate[] chain) {
        if (url == null) {
            return null;
        }
        return new TSAClientANF(url.getUrl(), chain, url.getUser(), url.getPass());
    }

    public static void setAccessKey(String key) {
        urlAccessKey = key;
    }
}

