/*
 * Decompiled with CFR 0.152.
 */
package com.anf.timestamp.exception;

import lombok.Generated;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.tsp.TSPException;

public class TSUFailureException
extends TSPException {
    private static final long serialVersionUID = 1L;
    private final int errorCode;
    private final String errorLabel;
    private final String statusString;

    public TSUFailureException(PKIStatusInfo status) {
        super(TSUFailureException.getMsg(status.getFailInfo(), status.getStatusString()));
        this.errorCode = status.getFailInfo().intValue();
        this.errorLabel = TSUFailureException.getErrorLabel(this.errorCode);
        PKIFreeText freeText = status.getStatusString();
        this.statusString = freeText != null && freeText.size() > 0 ? freeText.getStringAtUTF8(0).toString() : "";
    }

    public TSUFailureException(DERBitString failInfo, String freeText) {
        super(TSUFailureException.getMsg((ASN1BitString)failInfo, new PKIFreeText(freeText)));
        this.errorCode = failInfo.intValue();
        this.errorLabel = TSUFailureException.getErrorLabel(this.errorCode);
        this.statusString = freeText != null ? freeText : "";
    }

    private static String getMsg(ASN1BitString failInfo, PKIFreeText freeText) {
        int errorCode = failInfo.intValue();
        String errorLabel = TSUFailureException.getErrorLabel(errorCode);
        String msg = "PKIFailureInfo: " + errorLabel;
        if (freeText != null && freeText.size() > 0) {
            msg = msg + " | StatusString: " + freeText.getStringAtUTF8(0);
        }
        return msg;
    }

    private static String getErrorLabel(int errorCode2) {
        switch (errorCode2) {
            case 128: {
                return "badAlg";
            }
            case 64: {
                return "badMessageCheck";
            }
            case 32: {
                return "badRequest";
            }
            case 16: {
                return "badTime";
            }
            case 8: {
                return "badCertId";
            }
            case 4: {
                return "badDataFormat";
            }
            case 2: {
                return "wrongAuthority";
            }
            case 1: {
                return "incorrectData";
            }
            case 32768: {
                return "missingTimeStamp";
            }
            case 16384: {
                return "badPOP";
            }
        }
        return "notSupportedError";
    }

    public static void main(String[] args) throws TSUFailureException {
        throw new TSUFailureException(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText("error"), new PKIFailureInfo(32)));
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getErrorLabel() {
        return this.errorLabel;
    }

    @Generated
    public String getStatusString() {
        return this.statusString;
    }
}

