/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio.tools;

import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public class UtilsPcsc {
    private static final Logger log = LogManager.getLogger(UtilsPcsc.class);

    public static CommandAPDU getAPDU(String command) {
        String[] split = command.split(" ");
        if (split.length > 0) {
            byte[] c = new byte[split.length];
            for (int i = 0; i < split.length; ++i) {
                c[i] = (byte)Integer.parseInt(split[i], 16);
            }
            return new CommandAPDU(c);
        }
        return null;
    }

    public static void listTokens() throws Exception {
        TerminalFactory factory = TerminalFactory.getDefault();
        List<CardTerminal> terminals = factory.terminals().list();
        for (CardTerminal terminal : terminals) {
            log.info("Terminal: " + terminal.getName());
            if (!terminal.isCardPresent()) continue;
            log.info("    Card is connected");
            Card card = terminal.connect("*");
            ATR atr = card.getATR();
            log.info("card atr: {}", (Object)Hex.toHexString((byte[])atr.getBytes()));
        }
    }

    public static ResponseAPDU transmitAPDU(CardChannel cardChannel, String apdu) throws Exception {
        return UtilsPcsc.transmitAPDU(cardChannel, UtilsPcsc.getAPDU(apdu));
    }

    public static ResponseAPDU transmitAPDU(CardChannel cardChannel, CommandAPDU apdu) throws Exception {
        ResponseAPDU responseAPDU = cardChannel.transmit(apdu);
        if (responseAPDU.getSW1() == 97) {
            responseAPDU = cardChannel.transmit(new CommandAPDU(0, -64, 0, 0, responseAPDU.getSW2()));
        }
        return responseAPDU;
    }
}

