/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio.impl;

import com.anf.jna.smartcardio.JnaCard;
import com.anf.jna.smartcardio.JnaCardChannel;
import com.anf.jna.smartcardio.tools.UtilsPcsc;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class STCardTools {
    private static final Logger log = LogManager.getLogger(STCardTools.class);

    public static String getSerialNumber(JnaCardChannel channel) throws Exception {
        STCardTools.selectSerialNumberFile(channel);
        String command = "00 B0 00 12 08";
        CommandAPDU apdu = UtilsPcsc.getAPDU(command);
        ResponseAPDU responseAPDU = UtilsPcsc.transmitAPDU((CardChannel)channel, apdu);
        if (responseAPDU.getSW1() != 144 || responseAPDU.getSW2() != 0) {
            throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDU.getBytes()));
        }
        String response = STCardTools.toHexAPDU(responseAPDU.getData());
        log.info("Response " + response);
        byte[] cardSerialNumber = Arrays.copyOfRange(responseAPDU.getBytes(), 0, 8);
        String serialNumber = STCardTools.toHexAPDU(cardSerialNumber);
        try {
            new BigInteger(serialNumber, 10);
        }
        catch (Exception e) {
            serialNumber = new BigInteger(serialNumber, 16).toString();
        }
        return serialNumber;
    }

    public static void selectSerialNumberFile(JnaCardChannel cardChannel) throws Exception {
        String command = "00 A4 08 00 04 3F 00 2F 02 36";
        ResponseAPDU responseAPDU = UtilsPcsc.transmitAPDU((CardChannel)cardChannel, command);
        if (responseAPDU.getSW1() != 144 || responseAPDU.getSW2() != 0) {
            throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDU.getBytes()));
        }
        String response = STCardTools.toHexAPDU(responseAPDU.getData());
        log.info("Response " + response);
    }

    public byte[] getCardInfo(Card card) throws Exception {
        String command = "B0 FD 00 00 51";
        ResponseAPDU responseAPDU = UtilsPcsc.transmitAPDU(card.getBasicChannel(), command);
        if (responseAPDU.getSW1() != 144 || responseAPDU.getSW2() != 0) {
            throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDU.getBytes()));
        }
        return responseAPDU.getData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JnaCard getCard(String serialNumber, Predicate<byte[]> atrFilter) throws IOException {
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> terminals = factory.terminals().list();
            for (CardTerminal terminal : terminals) {
                CardChannel channel;
                Card card;
                ATR atr;
                if (!terminal.isCardPresent() || (atr = (card = terminal.connect("*")).getATR()) == null || !(card instanceof JnaCard)) continue;
                JnaCard jnaCard = (JnaCard)card;
                if (!atrFilter.test(atr.getBytes()) || (channel = card.getBasicChannel()) == null || !(channel instanceof JnaCardChannel)) continue;
                JnaCardChannel jnaChannel = (JnaCardChannel)channel;
                try {
                    String serial = STCardTools.getSerialNumber(jnaChannel);
                    if (serial == null || !serial.equals(serialNumber)) continue;
                    return jnaCard;
                }
                catch (Exception e) {
                    if (e.getMessage() == null || !e.getMessage().contains("SCARD_W_RESET_CARD")) throw e;
                    STCardTools.resetCard(jnaCard);
                    continue;
                    return null;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return null;
    }

    public static void resetCard(JnaCard card2) throws Exception {
        JnaCardChannel cardChannel = card2.getBasicChannel();
        ResponseAPDU responseAPDU = cardChannel.transmit(UtilsPcsc.getAPDU("00 A4 08 0C 02 2F FF"));
        if (responseAPDU.getSW1() == 144 && (responseAPDU = cardChannel.transmit(UtilsPcsc.getAPDU("00 20 00 90 08 31 38 37 33 35 39 31 30"))).getSW1() == 144 && (responseAPDU = cardChannel.transmit(UtilsPcsc.getAPDU("00 E4 00 00 02 20 41"))).getSW1() == 144) {
            responseAPDU = cardChannel.transmit(UtilsPcsc.getAPDU("00 E4 00 00 02 21 41"));
        }
    }

    public int getFreeEEPROM(String serialNumber, Predicate<byte[]> atrFilter) throws Exception {
        try {
            JnaCard card2 = STCardTools.getCard(serialNumber, atrFilter);
            if (card2 != null) {
                String command = "00 CA 01 8A 03";
                ResponseAPDU responseAPDU = UtilsPcsc.transmitAPDU((CardChannel)card2.getBasicChannel(), command);
                if (responseAPDU.getSW1() != 144 || responseAPDU.getSW2() != 0) {
                    throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDU.getBytes()));
                }
                return new BigInteger(responseAPDU.getData()).intValue();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return -1;
    }

    public static byte[] readFile(String serialNumber, Predicate<byte[]> atrFilter, String PIN) throws Exception {
        try {
            JnaCard card2 = STCardTools.getCard(serialNumber, atrFilter);
            if (card2 != null) {
                if (!atrFilter.test(((Card)card2).getATR().getBytes())) {
                    return null;
                }
                STCardTools.selectFile(card2);
                STCardTools.verifyPIN(card2, PIN);
                String command = "00 B0 00 00 63";
                ResponseAPDU responseAPDURead = UtilsPcsc.transmitAPDU(((Card)card2).getBasicChannel(), command);
                if (responseAPDURead.getSW1() != 144 || responseAPDURead.getSW2() != 0) {
                    throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDURead.getBytes()));
                }
                String response = STCardTools.toHexAPDU(responseAPDURead.getData());
                log.info("Response " + response);
                return responseAPDURead.getData();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return null;
    }

    public static boolean writeFile(String serialNumber, Predicate<byte[]> atrFilter, byte[] data, String PIN) throws Exception {
        try {
            JnaCard card2 = STCardTools.getCard(serialNumber, atrFilter);
            if (card2 != null) {
                if (!atrFilter.test(((Card)card2).getATR().getBytes())) {
                    return false;
                }
                STCardTools.selectFile(card2);
                STCardTools.verifyPIN(card2, PIN);
                byte count = (byte)data.length;
                String text = STCardTools.toHexAPDU(data);
                String command = "00 D6 00 00 " + STCardTools.ToHex(count) + " " + text;
                ResponseAPDU responseAPDU = UtilsPcsc.transmitAPDU(((Card)card2).getBasicChannel(), command);
                if (responseAPDU.getSW1() != 144 || responseAPDU.getSW2() != 0) {
                    throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDU.getBytes()));
                }
                String response = STCardTools.toHexAPDU(responseAPDU.getData());
                log.info("Response " + response);
                return true;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return false;
    }

    private static void verifyPIN(Card card, String PIN) throws Exception, IOException {
        String pin = STCardTools.toHexAPDU(PIN.getBytes());
        String command = "00 20 00 9A " + STCardTools.ToHex((byte)PIN.length()) + " " + pin;
        ResponseAPDU responseAPDU = UtilsPcsc.transmitAPDU(card.getBasicChannel(), command);
        if (responseAPDU.getSW1() != 144 || responseAPDU.getSW2() != 0) {
            throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDU.getBytes()));
        }
        String response = STCardTools.toHexAPDU(responseAPDU.getData());
        log.info("Response " + response);
    }

    private static void selectFile(Card card) throws Exception, IOException {
        String command = "00 A4 08 00 06 3F 00 13 00 13 01 1C";
        log.info(command);
        ResponseAPDU responseAPDU = UtilsPcsc.transmitAPDU(card.getBasicChannel(), command);
        if (responseAPDU.getSW1() != 144 || responseAPDU.getSW2() != 0) {
            throw new CardException("Get Info Card failed " + STCardTools.toHexAPDU(responseAPDU.getBytes()));
        }
        log.info("String " + new String(responseAPDU.getData()));
        String response = STCardTools.toHexAPDU(responseAPDU.getData());
        log.info("Response " + response);
    }

    private static String toHexAPDU(byte[] data) {
        if (data.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < data.length; ++i) {
                byte v = data[i];
                String hexString = STCardTools.ToHex(v);
                sb.append(hexString);
                if (i >= data.length - 1) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
        return "";
    }

    private static String ToHex(byte v) {
        Object hexString = Integer.toHexString(v);
        if (((String)hexString).length() > 2) {
            hexString = ((String)hexString).substring(((String)hexString).length() - 2);
        }
        if (((String)(hexString = ((String)hexString).toUpperCase())).length() == 1) {
            hexString = "0" + (String)hexString;
        }
        return hexString;
    }
}

