/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio;

import com.anf.jna.smartcardio.MacFunctionMapper;
import com.anf.jna.smartcardio.ScardIoRequest;
import com.anf.jna.smartcardio.WindowsFunctionMapper;
import com.anf.jna.smartcardio.WinscardLibInfo;
import com.anf.jna.smartcardio.WinscardLibrary;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.util.HashMap;

class Winscard {
    public static final String WINDOWS_PATH = "WinSCard.dll";
    public static final String MAC_PATH = "/System/Library/Frameworks/PCSC.framework/PCSC";
    public static final String PCSC_PATH = "libpcsclite.so.1";

    private Winscard() {
    }

    public static WinscardLibInfo openLib() {
        String libraryName = Platform.isWindows() ? WINDOWS_PATH : (Platform.isMac() ? MAC_PATH : PCSC_PATH);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (Platform.isWindows()) {
            options.put("function-mapper", new WindowsFunctionMapper());
        } else if (Platform.isMac()) {
            options.put("function-mapper", new MacFunctionMapper());
        }
        WinscardLibrary lib = (WinscardLibrary)Native.load((String)libraryName, WinscardLibrary.class, options);
        NativeLibrary nativeLibrary = NativeLibrary.getInstance((String)libraryName);
        ScardIoRequest SCARD_PCI_T0 = new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardT0Pci"));
        ScardIoRequest SCARD_PCI_T1 = new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardT1Pci"));
        ScardIoRequest SCARD_PCI_RAW = new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardRawPci"));
        SCARD_PCI_T0.read();
        SCARD_PCI_T1.read();
        SCARD_PCI_RAW.read();
        SCARD_PCI_T0.setAutoSynch(false);
        SCARD_PCI_T1.setAutoSynch(false);
        SCARD_PCI_RAW.setAutoSynch(false);
        return new WinscardLibInfo(lib, SCARD_PCI_T0, SCARD_PCI_T1, SCARD_PCI_RAW);
    }
}

