/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio;

import com.anf.jna.smartcardio.Dword;
import com.anf.jna.smartcardio.DwordByReference;
import com.anf.jna.smartcardio.JnaCardTerminal;
import com.anf.jna.smartcardio.JnaPCSCException;
import com.anf.jna.smartcardio.SCardContext;
import com.anf.jna.smartcardio.SCardReaderState;
import com.anf.jna.smartcardio.Smartcardio;
import com.anf.jna.smartcardio.WinscardLibInfo;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;

public class JnaCardTerminals
extends CardTerminals {
    final SCardContext scardContext;
    private final WinscardLibInfo libInfo;
    private SCardReaderState[] knownReaders;
    private final List<SCardReaderState> zombieReaders;
    private final boolean usePnp = true;
    private boolean isClosed;

    public JnaCardTerminals(WinscardLibInfo libInfo, SCardContext scardContext) {
        this.libInfo = libInfo;
        this.scardContext = scardContext;
        this.knownReaders = JnaCardTerminals.createScardReaderStates(Collections.emptyList(), true, new SCardReaderState[0]);
        this.zombieReaders = new ArrayList<SCardReaderState>();
    }

    @Override
    public List<CardTerminal> list(CardTerminals.State state) throws CardException {
        int i;
        List<String> filteredReaderNames;
        if (null == state) {
            throw new NullPointerException("State must be non-null. To get all terminals, call list() or list(State.ALL).");
        }
        if (state == CardTerminals.State.CARD_REMOVAL || state == CardTerminals.State.CARD_INSERTION) {
            boolean wasPresent;
            SCardReaderState readerState;
            int i2;
            ArrayList<CardTerminal> r = new ArrayList<CardTerminal>();
            for (i2 = 0; i2 < this.knownReaders.length; ++i2) {
                boolean shouldAdd;
                readerState = this.knownReaders[i2];
                if ("\\\\?PnP?\\Notification".equals(readerState.szReader)) continue;
                wasPresent = 0 != (readerState.dwCurrentState.intValue() & 0x20);
                boolean isPresent = 0 != (readerState.dwEventState.intValue() & 0x20);
                int oldCounter = readerState.dwCurrentState.intValue() >> 16 & 0xFFFF;
                int newCounter = readerState.dwEventState.intValue() >> 16 & 0xFFFF;
                boolean cardInserted = !wasPresent && isPresent || isPresent && oldCounter < newCounter || oldCounter + 1 < newCounter;
                boolean cardRemoved = wasPresent && !isPresent || !isPresent && oldCounter < newCounter || oldCounter + 1 < newCounter;
                boolean bl = shouldAdd = state == CardTerminals.State.CARD_INSERTION && cardInserted || state == CardTerminals.State.CARD_REMOVAL && cardRemoved;
                if (!shouldAdd) continue;
                r.add(new JnaCardTerminal(this.libInfo, this, readerState.szReader));
            }
            if (state == CardTerminals.State.CARD_REMOVAL) {
                for (i2 = 0; i2 < this.zombieReaders.size(); ++i2) {
                    readerState = this.zombieReaders.get(i2);
                    boolean bl = wasPresent = 0 != (readerState.dwCurrentState.intValue() & 0x20);
                    if (!wasPresent) continue;
                    r.add(new JnaCardTerminal(this.libInfo, this, readerState.szReader));
                }
            }
            return r;
        }
        List<String> readerNames = this.listReaderNames();
        if (readerNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (state == CardTerminals.State.ALL) {
            filteredReaderNames = readerNames;
        } else {
            SCardReaderState[] readers = new SCardReaderState[readerNames.size()];
            new SCardReaderState().toArray(readers);
            for (i = 0; i < readers.length; ++i) {
                readers[i].szReader = readerNames.get(i);
            }
            Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.scardContext, new Dword(0L), readers, new Dword(readers.length)));
            filteredReaderNames = new ArrayList<String>();
            boolean wantPresent = state == CardTerminals.State.CARD_PRESENT;
            for (int i3 = 0; i3 < readers.length; ++i3) {
                boolean isPresent;
                boolean bl = isPresent = 0 != (0x20 & readers[i3].dwEventState.intValue());
                if (wantPresent != isPresent) continue;
                filteredReaderNames.add(readers[i3].szReader);
            }
        }
        CardTerminal[] cardTerminals = new CardTerminal[filteredReaderNames.size()];
        for (i = 0; i < filteredReaderNames.size(); ++i) {
            String name = filteredReaderNames.get(i);
            cardTerminals[i] = new JnaCardTerminal(this.libInfo, this, name);
        }
        return Collections.unmodifiableList(Arrays.asList(cardTerminals));
    }

    private List<String> listReaderNames() throws JnaPCSCException {
        long err;
        DwordByReference pcchReaders = new DwordByReference();
        byte[] mszReaders = null;
        ByteBuffer mszReaderGroups = ByteBuffer.allocate("SCard$AllReaders".length() + 2);
        mszReaderGroups.put("SCard$AllReaders".getBytes(Charset.forName("ascii")));
        while ((err = this.libInfo.lib.SCardListReaders(this.scardContext, mszReaderGroups, null, pcchReaders).longValue()) == 0L && (int)(err = this.libInfo.lib.SCardListReaders(this.scardContext, mszReaderGroups, ByteBuffer.wrap(mszReaders = new byte[pcchReaders.getValue().intValue()]), pcchReaders).longValue()) == -2146435064) {
        }
        switch ((int)err) {
            case 0: {
                List<String> readerNames = Smartcardio.pcsc_multi2jstring(mszReaders);
                return readerNames;
            }
            case -2146435049: 
            case -2146435026: {
                return Collections.emptyList();
            }
        }
        Smartcardio.check("SCardListReaders", err);
        throw new IllegalStateException();
    }

    private static SCardReaderState[] createScardReaderStates(List<String> readerNames, boolean usePnp, SCardReaderState[] oldKnownReaders) {
        Structure[] newKnownReaders = new SCardReaderState[readerNames.size() + (usePnp ? 1 : 0)];
        new SCardReaderState().toArray(newKnownReaders);
        int i = 0;
        if (usePnp) {
            newKnownReaders[i].szReader = "\\\\?PnP?\\Notification";
            ++i;
        }
        for (String readerName : readerNames) {
            Structure newReader = newKnownReaders[i];
            newReader.szReader = readerName;
            SCardReaderState oldReader = null;
            for (int j = 0; j < oldKnownReaders.length; ++j) {
                if (!readerName.equals(oldKnownReaders[j].szReader)) continue;
                oldReader = oldKnownReaders[j];
                break;
            }
            if (oldReader != null) {
                newReader.dwCurrentState = oldReader.dwCurrentState;
                newReader.dwEventState = oldReader.dwEventState;
                newReader.cbAtr = oldReader.cbAtr;
                newReader.pvUserData = oldReader.pvUserData;
                System.arraycopy(oldReader.rgbAtr, 0, newReader.rgbAtr, 0, oldReader.cbAtr.intValue());
            }
            ++i;
        }
        return newKnownReaders;
    }

    private boolean updateKnownReaders() throws JnaPCSCException {
        List<String> currentReaderNames = this.listReaderNames();
        boolean isReaderAddedOrRemoved = false;
        int oldReaderCount = 0;
        for (SCardReaderState oldReader : this.knownReaders) {
            if ("\\\\?PnP?\\Notification".equals(oldReader.szReader)) continue;
            ++oldReaderCount;
            if (currentReaderNames.contains(oldReader.szReader)) continue;
            isReaderAddedOrRemoved = true;
            this.zombieReaders.add(oldReader);
        }
        boolean bl = isReaderAddedOrRemoved = isReaderAddedOrRemoved || oldReaderCount != currentReaderNames.size();
        if (!isReaderAddedOrRemoved) {
            return isReaderAddedOrRemoved;
        }
        this.knownReaders = JnaCardTerminals.createScardReaderStates(currentReaderNames, true, this.knownReaders);
        SCardReaderState[] readers = this.knownReaders.length == 0 ? new SCardReaderState[1] : this.knownReaders;
        Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.scardContext, new Dword(0L), readers, new Dword(this.knownReaders.length)));
        return true;
    }

    @Override
    public boolean waitForChange(long timeoutMs) throws CardException {
        boolean pnpChange;
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Negative timeout " + timeoutMs);
        }
        if (timeoutMs == 0L) {
            timeoutMs = -1L;
        }
        this.zombieReaders.clear();
        if ((Platform.isLinux() || Platform.isMac()) && this.updateKnownReaders()) {
            return true;
        }
        for (SCardReaderState reader : this.knownReaders) {
            reader.dwCurrentState = reader.dwEventState;
            reader.dwEventState = new Dword(0L);
        }
        SCardReaderState[] readers = this.knownReaders.length == 0 ? new SCardReaderState[1] : this.knownReaders;
        Dword statusError = this.libInfo.lib.SCardGetStatusChange(this.scardContext, new Dword(timeoutMs), readers, new Dword(readers.length));
        if (-2146435062 == statusError.intValue()) {
            return false;
        }
        Smartcardio.check("SCardGetStatusChange", statusError);
        SCardReaderState pnpReader = this.knownReaders[0];
        boolean bl = pnpChange = 0 != (pnpReader.dwEventState.intValue() & 2);
        if (pnpChange) {
            this.updateKnownReaders();
        }
        return true;
    }

    public String toString() {
        return String.format("%s{scardContext=%s}", new Object[]{this.getClass().getSimpleName(), this.scardContext});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JnaPCSCException {
        JnaCardTerminals jnaCardTerminals = this;
        synchronized (jnaCardTerminals) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        Smartcardio.check("SCardReleaseContext", this.libInfo.lib.SCardReleaseContext(this.scardContext));
    }

    public void finalize() throws JnaPCSCException {
        this.close();
    }
}

