/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio;

import com.anf.jna.smartcardio.Dword;
import com.anf.jna.smartcardio.DwordByReference;
import com.anf.jna.smartcardio.JnaCard;
import com.anf.jna.smartcardio.JnaCardException;
import com.anf.jna.smartcardio.JnaPCSCException;
import com.anf.jna.smartcardio.ScardIoRequest;
import com.anf.jna.smartcardio.Smartcardio;
import java.nio.ByteBuffer;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class JnaCardChannel
extends CardChannel {
    private final JnaCard card;
    private final int channel;
    private boolean isClosed;

    public JnaCardChannel(JnaCard card, int channel) {
        this.card = card;
        this.channel = channel;
    }

    @Override
    public void close() throws CardException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.channel != 0) {
            ByteBuffer command = ByteBuffer.wrap(new CommandAPDU(0, 112, 128, this.channel).getBytes());
            ByteBuffer response = ByteBuffer.allocate(2);
            this.transmitRaw(command, response);
            response.rewind();
            int sw = 0xFFFF & response.getShort();
            if (sw != 36864) {
                throw new JnaCardException(sw, "Could not close channel.");
            }
        } else {
            throw new IllegalStateException("Basic channel can not be closed");
        }
    }

    @Override
    public Card getCard() {
        return this.card;
    }

    @Override
    public int getChannelNumber() {
        return this.channel;
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU command) throws CardException {
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        byte[] commandCopy = command.getBytes();
        ByteBuffer response = this.transmitImpl(commandCopy, null);
        ResponseAPDU responseApdu = JnaCardChannel.convertResponse(response);
        return responseApdu;
    }

    @Override
    public int transmit(ByteBuffer command, ByteBuffer response) throws CardException {
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        byte[] commandCopy = new byte[command.remaining()];
        command.get(commandCopy);
        int startPosition = response.position();
        this.transmitImpl(commandCopy, response);
        int endPosition = response.position();
        return endPosition - startPosition;
    }

    private boolean isExtendedApdu(byte[] commandApdu) {
        return commandApdu.length >= 7 && commandApdu[4] == 0;
    }

    private ByteBuffer transmitImpl(byte[] command, ByteBuffer response) throws CardException, JnaPCSCException {
        if (this.card.protocol == 1 && this.isExtendedApdu(command)) {
            throw new CardException("Extended APDU requires T=1");
        }
        command[0] = JnaCardChannel.getClassByte(command[0], this.getChannelNumber());
        ByteBuffer commandBuffer = ByteBuffer.wrap(command);
        if (response == null) {
            response = ByteBuffer.allocate(8192);
        }
        for (int i = 0; i < 8; ++i) {
            int posBeforeTransmit = response.position();
            this.transmitRaw(commandBuffer, response);
            response.position(response.position() - 2);
            byte sw1 = response.get();
            byte sw2 = response.get();
            if (108 == sw1) {
                command[command.length - 1] = sw2;
                response.position(posBeforeTransmit);
                commandBuffer.rewind();
                continue;
            }
            if (97 != sw1) break;
            command[1] = -64;
            command[2] = 0;
            command[3] = 0;
            command[4] = sw2;
            commandBuffer.position(0);
            commandBuffer.limit(5);
            response.position(response.position() - 2);
        }
        return response;
    }

    static byte getClassByte(byte origCla, int channelNumber) {
        int cla;
        if ((0x80 & origCla) != 0) {
            return origCla;
        }
        if (0 <= channelNumber && channelNumber <= 3) {
            cla = origCla & 0x1C | channelNumber;
        } else if (4 <= channelNumber && channelNumber <= 19) {
            int channelBits = channelNumber - 4;
            cla = origCla & 0x30 | channelBits | 0x40;
        } else {
            throw new IllegalStateException("Bad channel number; expected 0-19; got " + channelNumber);
        }
        return (byte)cla;
    }

    private static ResponseAPDU convertResponse(ByteBuffer responseBuf) {
        byte[] responseBytes = new byte[responseBuf.position()];
        responseBuf.rewind();
        responseBuf.get(responseBytes);
        return new ResponseAPDU(responseBytes);
    }

    private int transmitRaw(ByteBuffer command, ByteBuffer response) throws JnaPCSCException {
        ScardIoRequest pioSendPci = new ScardIoRequest();
        pioSendPci.dwProtocol = new Dword(this.card.protocol);
        pioSendPci.cbPciLength = new Dword(pioSendPci.size());
        DwordByReference recvLength = new DwordByReference(new Dword(response.remaining()));
        Smartcardio.check("SCardTransmit", this.card.libInfo.lib.SCardTransmit(this.card.scardHandle, pioSendPci, command, new Dword(command.remaining()), null, response, recvLength));
        int recvLengthInt = recvLength.getValue().intValue();
        assert (recvLengthInt >= 0);
        command.position(command.limit());
        int newPosition = response.position() + recvLengthInt;
        response.position(newPosition);
        return recvLengthInt;
    }

    public String toString() {
        return String.format("%s{card=%s, channel=%d}", this.getClass().getSimpleName(), this.card, this.channel);
    }
}

