/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.modifications;

import eu.europa.esig.dss.enumerations.PdfObjectModificationType;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.modifications.PdfObjectTree;
import java.util.Objects;

public class ObjectModification {
    private final PdfObjectTree objectTree;
    private final PdfObject originalObject;
    private final PdfObject finalObject;
    private final PdfObjectModificationType objectModificationType;

    private ObjectModification(PdfObjectTree objectTree, PdfObject originalObject, PdfObject finalObject, PdfObjectModificationType objectModificationType) {
        this.objectTree = objectTree;
        this.originalObject = originalObject;
        this.finalObject = finalObject;
        this.objectModificationType = objectModificationType;
    }

    public static ObjectModification create(PdfObjectTree objectTree, PdfObject finalObject) {
        return new ObjectModification(objectTree, null, finalObject, PdfObjectModificationType.CREATION);
    }

    public static ObjectModification delete(PdfObjectTree objectTree, PdfObject originalObject) {
        return new ObjectModification(objectTree, originalObject, null, PdfObjectModificationType.DELETION);
    }

    public static ObjectModification modify(PdfObjectTree objectTree, PdfObject originalObject, PdfObject finalObject) {
        return new ObjectModification(objectTree, originalObject, finalObject, PdfObjectModificationType.MODIFICATION);
    }

    public PdfObjectTree getObjectTree() {
        return this.objectTree;
    }

    public PdfObject getOriginalObject() {
        return this.originalObject;
    }

    public PdfObject getFinalObject() {
        return this.finalObject;
    }

    public PdfObjectModificationType getActionType() {
        return this.objectModificationType;
    }

    public String getFieldName() {
        String fieldName = null;
        if (this.originalObject instanceof PdfDict) {
            fieldName = ((PdfDict)this.originalObject).getStringValue("T");
        } else if (this.finalObject instanceof PdfDict) {
            fieldName = ((PdfDict)this.finalObject).getStringValue("T");
        }
        return fieldName;
    }

    public String getType() {
        String type = null;
        if (this.originalObject instanceof PdfDict) {
            type = this.getType((PdfDict)this.originalObject);
        } else if (this.finalObject instanceof PdfDict) {
            type = this.getType((PdfDict)this.finalObject);
        }
        return type;
    }

    private String getType(PdfDict pdfDict) {
        PdfDict valueDict = pdfDict.getAsDict("V");
        if (valueDict != null) {
            return valueDict.getNameValue("Type");
        }
        return pdfDict.getNameValue("Type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectModification)) {
            return false;
        }
        ObjectModification that = (ObjectModification)o;
        if (!Objects.equals(this.objectTree, that.objectTree)) {
            return false;
        }
        return this.objectModificationType == that.objectModificationType;
    }

    public int hashCode() {
        int result = this.objectTree != null ? this.objectTree.hashCode() : 0;
        result = 31 * result + (this.objectModificationType != null ? this.objectModificationType.hashCode() : 0);
        return result;
    }
}

