/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.encryption;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.encryption.SecureRandomProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.crypto.prng.FixedSecureRandom;

public class DSSSecureRandomProvider
implements SecureRandomProvider {
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA512;
    private int binaryLength = 512;
    private PAdESCommonParameters parameters;
    private SignatureImageParameters imageParameters;

    public DSSSecureRandomProvider(PAdESCommonParameters parameters) {
        Objects.requireNonNull(parameters, "Parameters must be defined! Unable to instantiate DSSSecureRandomProvider.");
        this.parameters = parameters;
    }

    public DSSSecureRandomProvider(SignatureImageParameters imageParameters) {
        Objects.requireNonNull(imageParameters, "Parameters must be defined! Unable to instantiate DSSSecureRandomProvider.");
        this.imageParameters = imageParameters;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setBinaryLength(int binaryLength) {
        if (binaryLength < 16) {
            throw new IllegalArgumentException("The binaryLength cannot be less then 16 bytes!");
        }
        this.binaryLength = binaryLength;
    }

    @Override
    public SecureRandom getSecureRandom() {
        byte[] seed = this.buildSeed();
        byte[] value = DSSUtils.digest((DigestAlgorithm)this.digestAlgorithm, (byte[])seed);
        while (value.length < this.binaryLength) {
            value = Utils.concat((byte[][])new byte[][]{value, value});
        }
        value = Utils.subarray((byte[])value, (int)0, (int)this.binaryLength);
        return new FixedSecureRandom(value);
    }

    private byte[] buildSeed() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.parameters != null) {
                String subFilter;
                Date signingDate;
                SignatureImageParameters parametersImageParameters;
                String filter;
                baos.write(this.parameters.getContentSize());
                DigestAlgorithm parametersDigestAlgorithm = this.parameters.getDigestAlgorithm();
                if (parametersDigestAlgorithm != null) {
                    baos.write(parametersDigestAlgorithm.getName().getBytes());
                }
                if ((filter = this.parameters.getFilter()) != null) {
                    baos.write(filter.getBytes());
                }
                if ((parametersImageParameters = this.parameters.getImageParameters()) != null) {
                    baos.write(parametersImageParameters.toString().getBytes());
                }
                if ((signingDate = this.parameters.getSigningDate()) != null) {
                    baos.write((int)signingDate.getTime());
                }
                if ((subFilter = this.parameters.getSubFilter()) != null) {
                    baos.write(subFilter.getBytes());
                }
            } else if (this.imageParameters != null) {
                baos.write(this.imageParameters.toString().getBytes());
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to build a seed value. Reason : %s", e.getMessage()), (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }
}

