/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVriDict;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfCompositeDssDictCertificateSource
extends TokenCertificateSource {
    private final Map<PdfObjectKey, Set<CertificateToken>> certMap = new HashMap<PdfObjectKey, Set<CertificateToken>>();

    public void populateFromDssDictionary(PdfDssDict dssDictionary) {
        for (CertificateToken certToken : this.getDSSDictionaryCertValues(dssDictionary)) {
            this.addCertificate(certToken, CertificateOrigin.DSS_DICTIONARY);
        }
        for (CertificateToken certToken : this.getVRIDictionaryCertValues(dssDictionary)) {
            this.addCertificate(certToken, CertificateOrigin.VRI_DICTIONARY);
        }
    }

    private List<CertificateToken> getDSSDictionaryCertValues(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            Map<PdfObjectKey, CertificateToken> dssCerts = dssDictionary.getCERTs();
            this.populateObjectsMap(dssCerts);
            return new ArrayList<CertificateToken>(dssCerts.values());
        }
        return Collections.emptyList();
    }

    private List<CertificateToken> getVRIDictionaryCertValues(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            HashMap<PdfObjectKey, CertificateToken> vriCerts = new HashMap<PdfObjectKey, CertificateToken>();
            List<PdfVriDict> vris = dssDictionary.getVRIs();
            if (vris != null) {
                for (PdfVriDict vri : vris) {
                    vriCerts.putAll(vri.getCERTs());
                }
            }
            this.populateObjectsMap(vriCerts);
            return new ArrayList<CertificateToken>(vriCerts.values());
        }
        return Collections.emptyList();
    }

    private void populateObjectsMap(Map<PdfObjectKey, CertificateToken> certificateTokenMap) {
        for (Map.Entry<PdfObjectKey, CertificateToken> entry : certificateTokenMap.entrySet()) {
            Set<CertificateToken> certificateTokens = this.certMap.get(entry.getKey());
            if (certificateTokens == null) {
                certificateTokens = new HashSet<CertificateToken>();
            }
            certificateTokens.add(entry.getValue());
            this.certMap.put(entry.getKey(), certificateTokens);
        }
    }

    protected Set<CertificateToken> getCertificateTokensByObjectId(PdfObjectKey objectId) {
        return this.certMap.get(objectId);
    }
}

