/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.ByteRangeInputStream;
import java.io.InputStream;
import java.util.Objects;

public class PdfByteRangeDocument
extends CommonDocument {
    private static final long serialVersionUID = 7879399189697068569L;
    private final DSSDocument pdfDocument;
    private final ByteRange byteRange;

    public PdfByteRangeDocument(DSSDocument pdfDocument, ByteRange byteRange) {
        Objects.requireNonNull(pdfDocument, "PdfDocument cannot be null!");
        Objects.requireNonNull(byteRange, "ByteRange cannot be null!");
        this.pdfDocument = pdfDocument;
        this.byteRange = byteRange;
    }

    public ByteRange getByteRange() {
        return this.byteRange;
    }

    public InputStream openStream() {
        return new ByteRangeInputStream(this.pdfDocument.openStream(), this.byteRange);
    }
}

