/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.validation.CMSForPAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESBaselineRequirementsChecker
extends CAdESBaselineRequirementsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESBaselineRequirementsChecker.class);
    private static final String CONTENT_TYPE_ID_DATA = "1.2.840.113549.1.7.1";

    public PAdESBaselineRequirementsChecker(PAdESSignature signature, CertificateVerifier offlineCertificateVerifier) {
        super((CAdESSignature)signature, offlineCertificateVerifier);
    }

    protected SignatureForm getBaselineSignatureForm() {
        return SignatureForm.PAdES;
    }

    public boolean hasBaselineBProfile() {
        if (!this.cmsBaselineBRequirements()) {
            return false;
        }
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        PdfSignatureDictionary pdfSignatureDictionary = padesSignature.getPdfSignatureDictionary();
        if (pdfSignatureDictionary.getSigningDate() == null) {
            LOG.warn("Entry with the key M in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isArrayEmpty((byte[])pdfSignatureDictionary.getContents())) {
            LOG.warn("Entry with the key Contents in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isStringEmpty((String)pdfSignatureDictionary.getFilter())) {
            LOG.warn("Entry with the key Filter in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (pdfSignatureDictionary.getByteRange() == null) {
            LOG.warn("Entry with the key ByteRange in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isStringEmpty((String)pdfSignatureDictionary.getSubFilter())) {
            LOG.warn("Entry with the key SubFilter in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (!CONTENT_TYPE_ID_DATA.equals(padesSignature.getContentType())) {
            LOG.warn("content-type attribute shall have value 'id-data' for PAdES-BASELINE-B signature! (requirement (c))");
            return false;
        }
        if (Utils.isStringNotEmpty((String)pdfSignatureDictionary.getReason()) && Utils.isCollectionNotEmpty((Collection)padesSignature.getCommitmentTypeIndications())) {
            LOG.warn("commitment-type-indication attribute shall not be incorporated in the CMS signature when entry with a key Reason is used for PAdES-BASELINE-B signature! (requirement (d))");
            return false;
        }
        if (!"ETSI.CAdES.detached".equals(pdfSignatureDictionary.getSubFilter())) {
            LOG.warn("Entry with a key SubFilter shall contain a value 'ETSI.CAdES.detached' for PAdES-BASELINE-B signature! (requirement (l))");
            return false;
        }
        if ((Utils.isCollectionNotEmpty((Collection)padesSignature.getCommitmentTypeIndications()) || padesSignature.getSignaturePolicy() != null) && Utils.isStringNotEmpty((String)pdfSignatureDictionary.getReason())) {
            LOG.warn("Entry with a key Reason shall not be used when commitment-type-attribute or signature-policy-identifier is present in the CMS signature for PAdES-BASELINE-B signature! (requirement (m))");
            return false;
        }
        return true;
    }

    protected boolean cmsBaselineBRequirements() {
        CMSForPAdESBaselineRequirementsChecker cmsRequirementsChecker = new CMSForPAdESBaselineRequirementsChecker((CAdESSignature)this.signature);
        return cmsRequirementsChecker.isValidForPAdESBaselineBProfile();
    }

    public boolean hasBaselineTProfile() {
        if (Utils.isCollectionEmpty((Collection)((CAdESSignature)this.signature).getSignatureTimestamps()) && Utils.isCollectionEmpty((Collection)((CAdESSignature)this.signature).getDocumentTimestamps())) {
            LOG.trace("SignatureTimeStamp shall be present for BASELINE-T signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTProfile() {
        return this.hasLTProfile();
    }

    protected boolean hasLTProfile() {
        if (!this.minimalLTRequirement()) {
            return false;
        }
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        boolean allSelfSigned = this.getCertificateSourcesExceptLastArchiveTimestamp().isAllSelfSigned();
        if (!allSelfSigned && padesSignature.getDssDictionary() == null) {
            LOG.debug("DSS dictionary shall be present for PAdES-BASELINE-LT signature! (cardinality >= 1)");
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTAProfile() {
        if (!this.isBaselineLTATimestampPresent()) {
            LOG.debug("document-time-stamp covering LT-level and containing a key SubFilter with value ETSI.RFC3161 shall be present for PAdES-BASELINE-LTA signature! (cardinality >= 1, requirement (y))");
            return false;
        }
        return true;
    }

    private boolean isBaselineLTATimestampPresent() {
        for (TimestampToken timestampToken : ((CAdESSignature)this.signature).getDocumentTimestamps()) {
            if (!this.isBaselineLTATimestamp(timestampToken)) continue;
            return true;
        }
        return false;
    }

    private boolean isBaselineLTATimestamp(TimestampToken timestampToken) {
        return this.containsRFC3161SubFilter(timestampToken) && this.coversLTLevelData(timestampToken);
    }

    public boolean hasExtendedBESProfile() {
        if (!this.cmsExtendedBESRequirements()) {
            return false;
        }
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        CMSSignedData cmsSignedData = padesSignature.getCmsSignedData();
        PdfSignatureDictionary pdfSignatureDictionary = padesSignature.getPdfSignatureDictionary();
        if (cmsSignedData == null) {
            LOG.warn("DER-encoded SignedData object shall be included as the PDF signature in the entry with the key Contents of the Signature Dictionary for PAdES-BES signature (PAdES Part 1, requirement (a))!");
            return false;
        }
        if (cmsSignedData.getSignerInfos().size() != 1) {
            LOG.warn("There shall be a single signer for any PAdES-BES signature (PAdES Part 1, requirement (a))!");
            return false;
        }
        if (!padesSignature.getCmsSignedData().isDetachedSignature()) {
            LOG.warn("No data shall be encapsulated in the PKCS#7 SignedData field for PAdES-BES signature (PAdES Part 1, requirement (b))!");
            return false;
        }
        if (Utils.isStringEmpty((String)pdfSignatureDictionary.getFilter())) {
            LOG.warn("Entry with the key Filter in the Signature Dictionary shall be present for PAdES-BES signature (cardinality == 1)!");
            return false;
        }
        if (pdfSignatureDictionary.getByteRange() == null) {
            LOG.warn("Entry with the key ByteRange in the Signature Dictionary shall be present for PAdES-BES signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isStringEmpty((String)pdfSignatureDictionary.getSubFilter())) {
            LOG.warn("Entry with the key SubFilter in the Signature Dictionary shall be present for PAdES-BES signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isArrayEmpty((byte[])pdfSignatureDictionary.getContents())) {
            LOG.warn("Entry with the key Contents in the Signature Dictionary shall be present for PAdES-BES signature (cardinality == 1)!");
            return false;
        }
        if (!CONTENT_TYPE_ID_DATA.equals(padesSignature.getContentType())) {
            LOG.warn("content-type attribute shall have value 'id-data' for PAdES-BES signature! (requirement (a))");
            return false;
        }
        if (Utils.isStringNotEmpty((String)pdfSignatureDictionary.getReason()) && Utils.isCollectionNotEmpty((Collection)padesSignature.getCommitmentTypeIndications())) {
            LOG.warn("commitment-type-indication attribute shall not be incorporated in the CMS signature when entry with a key Reason is used for PAdES-BES signature! (requirement (e))");
            return false;
        }
        if (!"ETSI.CAdES.detached".equals(pdfSignatureDictionary.getSubFilter())) {
            LOG.warn("Entry with a key SubFilter shall contain a value 'ETSI.CAdES.detached' for PAdES-BES signature! (requirement (j))");
            return false;
        }
        return true;
    }

    public boolean hasExtendedEPESProfile() {
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        SignerInformation signerInformation = padesSignature.getSignerInformation();
        PdfSignatureDictionary pdfSignatureDictionary = padesSignature.getPdfSignatureDictionary();
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes((SignerInformation)signerInformation, (ASN1ObjectIdentifier)PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) == 0) {
            LOG.debug("signature-policy-identifier attribute shall be present for PAdES-EPES signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isStringNotEmpty((String)pdfSignatureDictionary.getReason())) {
            LOG.warn("Entry with the key Reason in the Signature Dictionary shall not be present for PAdES-EPES signature (cardinality == 0)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedLTVProfile() {
        if (!this.minimalLTRequirement()) {
            return false;
        }
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        boolean allSelfSigned = this.getCertificateSourcesExceptLastArchiveTimestamp().isAllSelfSigned();
        if (!allSelfSigned && padesSignature.getDssDictionary() == null) {
            LOG.debug("DSS dictionary shall be present for PAdES-LTV signature!");
            return false;
        }
        if (!this.isLTVTimestampPresent()) {
            LOG.debug("document-time-stamp covering validation data shall be present for PAdES-LTV signature!");
            return false;
        }
        return true;
    }

    private boolean isLTVTimestampPresent() {
        for (TimestampToken timestampToken : ((CAdESSignature)this.signature).getDocumentTimestamps()) {
            if (!this.coversLTLevelData(timestampToken)) continue;
            return true;
        }
        return false;
    }

    private boolean coversLTLevelData(TimestampToken timestampToken) {
        if (ArchiveTimestampType.PAdES.equals((Object)timestampToken.getArchiveTimestampType())) {
            ValidationContext validationContext = this.getValidationContext();
            ValidationData signatureValidationData = validationContext.getValidationData((AdvancedSignature)this.signature);
            Set certificateTokens = signatureValidationData.getCertificateTokens();
            Set crlTokens = signatureValidationData.getCrlTokens();
            Set ocspTokens = signatureValidationData.getOcspTokens();
            List allTimestamps = ((CAdESSignature)this.signature).getAllTimestamps();
            if (Utils.isCollectionEmpty((Collection)crlTokens) && Utils.isCollectionEmpty((Collection)ocspTokens)) {
                return this.coversDSSCertificateTokens(timestampToken, certificateTokens);
            }
            return this.coversRevocationTokens(timestampToken, crlTokens, ocspTokens) && (this.coversTimestampTokens(timestampToken, allTimestamps) || this.coversOwnRevocationData(timestampToken));
        }
        return false;
    }

    private boolean coversDSSCertificateTokens(TimestampToken timestampToken, Collection<CertificateToken> certificateTokens) {
        ArrayList dssCertificates = new ArrayList();
        dssCertificates.addAll(((CAdESSignature)this.signature).getCertificateSource().getDSSDictionaryCertValues());
        dssCertificates.addAll(((CAdESSignature)this.signature).getCertificateSource().getVRIDictionaryCertValues());
        if (Utils.isCollectionNotEmpty(dssCertificates)) {
            for (CertificateToken certificateToken : certificateTokens) {
                if (!dssCertificates.contains(certificateToken) || !this.coversToken(timestampToken, (Token)certificateToken)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean coversRevocationTokens(TimestampToken timestampToken, Collection<CRLToken> crlTokens, Collection<OCSPToken> ocspTokens) {
        Map<String, Collection<RevocationToken<?>>> revocationsByCertificate = this.getRevocationsByCertificate(crlTokens, ocspTokens);
        for (Collection<RevocationToken<?>> revocationTokens : revocationsByCertificate.values()) {
            boolean revocationForCertificateIsCovered = false;
            for (RevocationToken<?> revocationToken : revocationTokens) {
                if (!this.coversToken(timestampToken, (Token)revocationToken)) continue;
                revocationForCertificateIsCovered = true;
                break;
            }
            if (revocationForCertificateIsCovered) continue;
            return false;
        }
        return true;
    }

    private boolean coversTimestampTokens(TimestampToken timestampToken, Collection<TimestampToken> signatureTimestampTokens) {
        List timestampedReferences = timestampToken.getTimestampedReferences();
        if (Utils.isCollectionNotEmpty((Collection)timestampedReferences)) {
            for (TimestampToken sigTst : signatureTimestampTokens) {
                if (!timestampedReferences.stream().anyMatch(r -> sigTst.getDSSIdAsString().equals(r.getObjectId()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean coversOwnRevocationData(TimestampToken timestampToken) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.offlineCertificateVerifier);
        validationContext.addDocumentCertificateSource(((CAdESSignature)this.signature).getCompleteCertificateSource());
        validationContext.addDocumentCRLSource(((CAdESSignature)this.signature).getCompleteCRLSource());
        validationContext.addDocumentOCSPSource(((CAdESSignature)this.signature).getCompleteOCSPSource());
        validationContext.addTimestampTokenForVerification(timestampToken);
        validationContext.validate();
        ValidationData validationData = validationContext.getValidationData(timestampToken);
        HashSet revocationTokenIdentifiers = new HashSet();
        revocationTokenIdentifiers.addAll(validationData.getCrlTokens().stream().map(Token::getDSSIdAsString).collect(Collectors.toSet()));
        revocationTokenIdentifiers.addAll(validationData.getOcspTokens().stream().map(Token::getDSSIdAsString).collect(Collectors.toSet()));
        if (Utils.isCollectionEmpty(revocationTokenIdentifiers)) {
            return validationContext.checkAllRequiredRevocationDataPresent();
        }
        List timestampedReferences = timestampToken.getTimestampedReferences();
        return timestampedReferences.stream().anyMatch(r -> revocationTokenIdentifiers.contains(r.getObjectId()));
    }

    private Map<String, Collection<RevocationToken<?>>> getRevocationsByCertificate(Collection<CRLToken> crlTokens, Collection<OCSPToken> ocspTokens) {
        HashMap result = new HashMap();
        this.enrichRevocationDataMap(result, crlTokens);
        this.enrichRevocationDataMap(result, ocspTokens);
        return result;
    }

    private <R extends RevocationToken<?>> void enrichRevocationDataMap(Map<String, Collection<RevocationToken<?>>> revocationDataMap, Collection<R> revocationData) {
        for (RevocationToken revocationToken : revocationData) {
            String relatedCertificateId = revocationToken.getRelatedCertificateId();
            Collection<RevocationToken<?>> relatedRevocationData = revocationDataMap.get(relatedCertificateId);
            if (Utils.isCollectionEmpty(relatedRevocationData)) {
                relatedRevocationData = new HashSet();
                revocationDataMap.put(relatedCertificateId, relatedRevocationData);
            }
            relatedRevocationData.add(revocationToken);
        }
    }

    private boolean coversToken(TimestampToken timestampToken, Token token) {
        List timestampedReferences = timestampToken.getTimestampedReferences();
        for (TimestampedReference timestampedReference : timestampedReferences) {
            if (!token.getDSSIdAsString().equals(timestampedReference.getObjectId())) continue;
            return true;
        }
        return false;
    }

    private boolean containsRFC3161SubFilter(TimestampToken timestampToken) {
        PdfDocTimestampRevision pdfRevision;
        if (timestampToken instanceof PdfTimestampToken && (pdfRevision = ((PdfTimestampToken)timestampToken).getPdfRevision()) != null) {
            PdfSignatureDictionary pdfSigDictInfo = pdfRevision.getPdfSigDictInfo();
            return pdfSigDictInfo != null && "ETSI.RFC3161".equals(pdfSigDictInfo.getSubFilter());
        }
        return false;
    }

    public boolean hasPKCS7Profile() {
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        PdfSignatureDictionary pdfSignatureDictionary = padesSignature.getPdfSignatureDictionary();
        if (!"adbe.pkcs7.detached".equals(pdfSignatureDictionary.getSubFilter()) && !"adbe.pkcs7.sha1".equals(pdfSignatureDictionary.getSubFilter())) {
            LOG.debug("Entry with a key SubFilter shall have a value adbe.pkcs7.detached or adbe.pkcs7.sha1 for PKCS#7 signature!");
            return false;
        }
        if (!this.containsSigningCertificate(padesSignature.getCertificateSource().getCertificates())) {
            LOG.warn("PKCS#7 signature shall include signing certificate!");
            return false;
        }
        if ("adbe.pkcs7.detached".equals(pdfSignatureDictionary.getSubFilter())) {
            if (Utils.isArrayEmpty((byte[])padesSignature.getMessageDigestValue())) {
                LOG.warn("PKCS#7 signature shall include message digest!");
                return false;
            }
            if (!padesSignature.getCmsSignedData().isDetachedSignature()) {
                LOG.warn("No data shall be encapsulated in the CMS SignedData field for PKCS#7 signature!");
                return false;
            }
        }
        if ("adbe.pkcs7.sha1".equals(pdfSignatureDictionary.getSubFilter())) {
            CMSTypedData signedContent = padesSignature.getCmsSignedData().getSignedContent();
            if (signedContent == null) {
                LOG.warn("ContentInfo of type Data shall be encapsulated in the CMS SignedData field for PKCS#7 signature with SHA-1 SubFilter!");
                return false;
            }
            byte[] signedContentBytes = CMSUtils.getSignedContent((CMSTypedData)signedContent);
            if (!DSSUtils.isSHA1Digest((String)Utils.toHex((byte[])signedContentBytes))) {
                LOG.warn("The SHA-1 digest of the document\u2019s byte range shall be encapsulated in the CMS SignedData field with ContentInfo of type Data for PKCS#7 signature with SHA-1 SubFilter!");
                return false;
            }
        }
        return true;
    }

    public boolean hasPKCS7TProfile() {
        return this.hasBaselineTProfile();
    }

    public boolean hasPKCS7LTProfile() {
        return this.hasLTProfile();
    }

    public boolean hasPKCS7LTAProfile() {
        boolean ltaTimestampFound = false;
        for (TimestampToken timestampToken : ((CAdESSignature)this.signature).getDocumentTimestamps()) {
            if (!this.coversLTLevelData(timestampToken)) continue;
            ltaTimestampFound = true;
            break;
        }
        if (!ltaTimestampFound) {
            LOG.debug("document-time-stamp covering LT-level shall be present for PKCS#7-LTA signature!");
            return false;
        }
        return true;
    }
}

