/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextPosition;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.enumerations.TextWrapping;
import eu.europa.esig.dss.pades.DSSFileFont;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.utils.Utils;
import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;

public class SignatureImageTextParameters
implements Serializable {
    private static final long serialVersionUID = 727438728149346847L;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private static final float DEFAULT_PADDING = 5.0f;
    private static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private SignerTextPosition signerTextPosition = SignerTextPosition.LEFT;
    private SignerTextVerticalAlignment signerTextVerticalAlignment = SignerTextVerticalAlignment.MIDDLE;
    private SignerTextHorizontalAlignment signerTextHorizontalAlignment = SignerTextHorizontalAlignment.LEFT;
    private String text;
    private DSSFont dssFont;
    private TextWrapping textWrapping = TextWrapping.FONT_BASED;
    private float padding = 5.0f;
    private Color textColor = DEFAULT_TEXT_COLOR;
    private Color backgroundColor = DEFAULT_BACKGROUND_COLOR;

    public SignerTextPosition getSignerTextPosition() {
        return this.signerTextPosition;
    }

    public void setSignerTextPosition(SignerTextPosition signerTextPosition) {
        this.signerTextPosition = signerTextPosition;
    }

    public SignerTextVerticalAlignment getSignerTextVerticalAlignment() {
        return this.signerTextVerticalAlignment;
    }

    public void setSignerTextVerticalAlignment(SignerTextVerticalAlignment signerTextVerticalAlignment) {
        this.signerTextVerticalAlignment = signerTextVerticalAlignment;
    }

    public SignerTextHorizontalAlignment getSignerTextHorizontalAlignment() {
        return this.signerTextHorizontalAlignment;
    }

    public void setSignerTextHorizontalAlignment(SignerTextHorizontalAlignment signerTextHorizontalAlignment) {
        this.signerTextHorizontalAlignment = signerTextHorizontalAlignment;
    }

    public DSSFont getFont() {
        if (this.dssFont == null) {
            this.dssFont = DSSFileFont.initializeDefault();
        }
        return this.dssFont;
    }

    public void setFont(DSSFont dssFont) {
        this.dssFont = dssFont;
    }

    public TextWrapping getTextWrapping() {
        return this.textWrapping;
    }

    public void setTextWrapping(TextWrapping textWrapping) {
        Objects.requireNonNull(textWrapping, "TextWrapping cannot be null!");
        this.textWrapping = textWrapping;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isEmpty() {
        return Utils.isStringEmpty((String)this.text);
    }

    public String toString() {
        return "SignatureImageTextParameters [signerTextPosition=" + this.signerTextPosition + ", signerTextVerticalAlignment=" + this.signerTextVerticalAlignment + ", signerTextHorizontalAlignment=" + this.signerTextHorizontalAlignment + ", text='" + this.text + '\'' + ", dssFont=" + this.dssFont + ", textWrapping=" + this.textWrapping + ", padding=" + this.padding + ", textColor=" + this.textColor + ", backgroundColor=" + this.backgroundColor + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureImageTextParameters that = (SignatureImageTextParameters)o;
        return Float.compare(this.padding, that.padding) == 0 && this.signerTextPosition == that.signerTextPosition && this.signerTextVerticalAlignment == that.signerTextVerticalAlignment && this.signerTextHorizontalAlignment == that.signerTextHorizontalAlignment && Objects.equals(this.text, that.text) && Objects.equals(this.dssFont, that.dssFont) && this.textWrapping == that.textWrapping && Objects.equals(this.textColor, that.textColor) && Objects.equals(this.backgroundColor, that.backgroundColor);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.signerTextPosition);
        result = 31 * result + Objects.hashCode(this.signerTextVerticalAlignment);
        result = 31 * result + Objects.hashCode(this.signerTextHorizontalAlignment);
        result = 31 * result + Objects.hashCode(this.text);
        result = 31 * result + Objects.hashCode(this.dssFont);
        result = 31 * result + Objects.hashCode(this.textWrapping);
        result = 31 * result + Float.hashCode(this.padding);
        result = 31 * result + Objects.hashCode(this.textColor);
        result = 31 * result + Objects.hashCode(this.backgroundColor);
        return result;
    }
}

