/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

public enum TokenExtractionStrategy {
    EXTRACT_ALL(true, true, true, true),
    EXTRACT_CERTIFICATES_ONLY(true, false, false, false),
    EXTRACT_TIMESTAMPS_ONLY(false, true, false, false),
    EXTRACT_REVOCATION_DATA_ONLY(false, false, true, false),
    EXTRACT_EVIDENCE_RECORDS_ONLY(false, false, false, true),
    EXTRACT_CERTIFICATES_AND_TIMESTAMPS(true, true, false, false),
    EXTRACT_CERTIFICATES_AND_EVIDENCE_RECORDS(true, false, false, true),
    EXTRACT_CERTIFICATES_AND_TIMESTAMPS_AND_EVIDENCE_RECORDS(true, true, false, true),
    EXTRACT_CERTIFICATES_AND_REVOCATION_DATA(true, false, true, false),
    EXTRACT_CERTIFICATES_AND_TIMESTAMPS_AND_REVOCATION_DATA(true, true, true, false),
    EXTRACT_CERTIFICATES_AND_REVOCATION_DATA_AND_EVIDENCE_RECORDS(true, false, true, true),
    EXTRACT_TIMESTAMPS_AND_REVOCATION_DATA(false, true, true, false),
    EXTRACT_TIMESTAMPS_AND_EVIDENCE_RECORDS(false, true, false, true),
    EXTRACT_REVOCATION_DATA_AND_EVIDENCE_RECORDS(false, false, true, true),
    EXTRACT_TIMESTAMPS_AND_REVOCATION_DATA_AND_EVIDENCE_RECORDS(false, true, true, true),
    NONE(false, false, false, false);

    private final boolean certificate;
    private final boolean timestamp;
    private final boolean revocationData;
    private final boolean evidenceRecord;

    private TokenExtractionStrategy(boolean certificate, boolean timestamp, boolean revocationData, boolean evidenceRecord) {
        this.certificate = certificate;
        this.timestamp = timestamp;
        this.revocationData = revocationData;
        this.evidenceRecord = evidenceRecord;
    }

    public boolean isCertificate() {
        return this.certificate;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public boolean isRevocationData() {
        return this.revocationData;
    }

    public boolean isEvidenceRecord() {
        return this.evidenceRecord;
    }

    public static TokenExtractionStrategy fromParameters(boolean certificate, boolean timestamp, boolean revocationData, boolean evidenceRecord) {
        for (TokenExtractionStrategy value : TokenExtractionStrategy.values()) {
            if (certificate != value.certificate || timestamp != value.timestamp || revocationData != value.revocationData || evidenceRecord != value.evidenceRecord) continue;
            return value;
        }
        return NONE;
    }
}

