/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.OidDescription;

public enum SemanticsIdentifier implements OidDescription
{
    qcsSemanticsIdNatural("qcs-semanticsId-Natural", "0.4.0.194121.1.1", "Semantics identifier for natural person"),
    qcsSemanticsIdLegal("qcs-SemanticsId-Legal", "0.4.0.194121.1.2", "Semantics identifier for legal person"),
    qcsSemanticsIdEIDASNatural("qcs-semanticsId-eIDASNatural", "0.4.0.194121.1.3", "Semantics identifier for eIDAS natural person"),
    qcsSemanticsIdEIDASLegal("qcs-SemanticsId-eIDASLegal", "0.4.0.194121.1.4", "Semantics identifier for eIDAS legal person");

    private final String name;
    private final String oid;
    private final String description;

    private SemanticsIdentifier(String name, String oid, String description) {
        this.name = name;
        this.oid = oid;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static SemanticsIdentifier fromName(String name) {
        for (SemanticsIdentifier semanticsIdentifier : SemanticsIdentifier.values()) {
            if (!semanticsIdentifier.name.equals(name)) continue;
            return semanticsIdentifier;
        }
        return null;
    }

    public static SemanticsIdentifier fromOid(String oid) {
        for (SemanticsIdentifier semanticsIdentifier : SemanticsIdentifier.values()) {
            if (!semanticsIdentifier.oid.equals(oid)) continue;
            return semanticsIdentifier;
        }
        return null;
    }
}

