/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.ssl;

import com.anf.cert.profile.PSD2SSLProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.EVAttributes;
import com.anf.cert.profile.attributes.PSD2Attributes;
import com.anf.cert.profile.impl.ssl.EVSSLProfileImpl;
import com.anf.cryptotoken.oid.IANACode;
import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.cryptotoken.oid.ProfilePolicy;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;

public final class PSD2SSLProfileImpl
extends EVSSLProfileImpl
implements PSD2SSLProfile {
    private PSD2Attributes psd2Attributes;

    public PSD2SSLProfileImpl() {
    }

    public PSD2SSLProfileImpl(CertAttributes certAttributes, EVAttributes evAttributes, PSD2Attributes psd2Attributes, String ... domains) {
        super(certAttributes, evAttributes, domains);
        this.psd2Attributes = psd2Attributes;
    }

    @Override
    protected ProfilePolicy profilePolicy() {
        return ProfilePolicy.SSL_PSD2_OLD;
    }

    @Override
    public String getTypeName() {
        return "SSL_PSD2";
    }

    @Override
    protected void addLastSubjectFields(List<RDN> subjectFields) {
        String orgField = this.psd2Attributes.buildOrgField();
        this.addSubjectField(subjectFields, new ASN1ObjectIdentifier("2.5.4.97"), orgField, true);
    }

    @Override
    public String getRegistrationSchemeId() {
        return "PSD";
    }

    @Override
    public String getRegistrationReference() {
        return this.psd2Attributes.getIdNCA() + "-" + this.psd2Attributes.getAuthNumber();
    }

    @Override
    public PSD2Attributes getPsd2Attributes() {
        return this.psd2Attributes;
    }

    @Override
    public void setPsd2Attributes(PSD2Attributes psd2Attributes) {
        this.psd2Attributes = psd2Attributes;
    }

    @Override
    public void init() {
        EVAttributes attrs = this.getEvAttributes();
        if (attrs != null) {
            if (attrs.getJurisdictionLocalityName() != null && attrs.getJurisdictionLocalityName().isEmpty()) {
                attrs.setJurisdictionLocalityName(null);
            }
            if (attrs.getJurisdictionStateOrProvinceName() != null && attrs.getJurisdictionStateOrProvinceName().isEmpty()) {
                attrs.setJurisdictionStateOrProvinceName(null);
            }
        }
        super.init();
        if (this.policyOid == null) {
            this.policyOid = PolicyOID.fromIANACode((String)IANACode.ANF_ES.getIanaCode()).oid(ProfilePolicy.SSL_PSD2_OLD);
        }
    }

    @Override
    protected String getOUSuffix() {
        return "PSD2";
    }

    @Override
    protected String defaultOrgUnit() {
        return "Certificado Cualificado de Servidor Seguro SSL PSD2";
    }
}

