/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.ssl;

import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.PersonAttributes;
import com.anf.cert.profile.impl.ssl.BaselineSSLProfile;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.bouncycastle.asn1.x509.GeneralName;

public class IVSSLProfileImpl
extends BaselineSSLProfile {
    private PersonAttributes personAttributes;

    public IVSSLProfileImpl() {
    }

    public IVSSLProfileImpl(CertAttributes certAttributes, PersonAttributes personAttributes, String ... domains) {
        super(certAttributes, domains);
        this.personAttributes = personAttributes;
    }

    @Override
    protected ProfilePolicy profilePolicy() {
        return ProfilePolicy.SSL_IV_OLD;
    }

    @Override
    public String getTypeName() {
        return "SSL_IV";
    }

    public PersonAttributes getPersonAttributes() {
        return this.personAttributes;
    }

    @Override
    @JsonIgnore
    public List<GeneralName> getSubjectAltNames() {
        List<GeneralName> names = super.getSubjectAltNames();
        String name = this.personAttributes.getName();
        String surname = this.personAttributes.getSurname();
        String mail = this.personAttributes.getMail();
        if (name != null) {
            names.add(new GeneralName(1, name));
        }
        if (surname != null) {
            names.add(new GeneralName(1, surname));
        }
        if (mail != null) {
            names.add(new GeneralName(1, mail));
        }
        return names;
    }

    @Override
    public boolean includeQcStatements() {
        return false;
    }

    @Override
    protected String getOUSuffix() {
        return "IV";
    }
}

