/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.ssl;

import com.anf.cert.profile.SSLProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.impl.BaselineCertProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.x509.GeneralName;

public abstract class BaselineSSLProfile
extends BaselineCertProfile
implements SSLProfile {
    private List<String> domains;

    protected BaselineSSLProfile() {
    }

    protected BaselineSSLProfile(CertAttributes certAttributes, String ... domains) {
        super(certAttributes);
        this.domains = new ArrayList<String>();
        if (domains != null && domains.length > 0) {
            for (String domain : domains) {
                this.domains.add(domain);
            }
        }
        this.validity = 365;
        this.validityUnit = TimeUnit.DAYS.name();
    }

    @Override
    public List<String> getDomains() {
        return this.domains;
    }

    @Override
    public String getTypeName() {
        return "SSL_BASELINE";
    }

    @Override
    public int getKeyLength() {
        return this.certAttributes.getKeySize();
    }

    @Override
    public CertAttributes getCertAttributes() {
        return this.certAttributes;
    }

    @Override
    @JsonIgnore
    public List<GeneralName> getSubjectAltNames() {
        ArrayList<GeneralName> names = new ArrayList<GeneralName>();
        List<String> domains = this.getDomains();
        domains.forEach(domain -> {
            GeneralName name = new GeneralName(2, domain);
            names.add(name);
        });
        return names;
    }

    @Override
    public boolean includeQcStatements() {
        return true;
    }

    @Override
    protected String getOrganizationalUnit() {
        if (this.certAttributes != null) {
            try {
                boolean ouForbidden = new Date().after(new SimpleDateFormat("yyyy-MM-dd").parse("2022-08-31"));
                if (ouForbidden) {
                    this.certAttributes.setDepartment(null);
                } else {
                    this.certAttributes.setDepartment(this.defaultOrgUnit());
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return super.getOrganizationalUnit();
    }

    protected String defaultOrgUnit() {
        return "Certificado de Servidor Seguro SSL " + this.getOUSuffix();
    }

    protected abstract String getOUSuffix();
}

