/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.seal;

import com.anf.cert.profile.PSD2SealProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.PSD2Attributes;
import com.anf.cert.profile.attributes.SealAttributes;
import com.anf.cert.profile.impl.seal.SealProfileImpl;
import com.anf.cryptotoken.oid.ProfilePolicy;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;

public final class SealProfilePSD2
extends SealProfileImpl
implements PSD2SealProfile {
    private PSD2Attributes psd2Attributes;

    public SealProfilePSD2() {
    }

    public SealProfilePSD2(CertAttributes certAttributes, SealAttributes attributes, PSD2Attributes psd2Attributes) {
        super(certAttributes, attributes);
        this.psd2Attributes = psd2Attributes;
    }

    @Override
    protected ProfilePolicy profilePolicy() {
        return ProfilePolicy.QSeal_PSD2_Software;
    }

    @Override
    public PSD2Attributes getPsd2Attributes() {
        return this.psd2Attributes;
    }

    @Override
    public void setPsd2Attributes(PSD2Attributes psd2Attributes) {
        this.psd2Attributes = psd2Attributes;
    }

    @Override
    public String getTypeName() {
        return "QSEAL_PSD2";
    }

    @Override
    protected void addFirstSubjectFields(List<RDN> subjectFields) {
        this.addSubjectField(subjectFields, BCStyle.SERIALNUMBER, this.certAttributes.getSerialNumber(), true);
    }

    @Override
    protected void addCIF(List<RDN> subjectFields) {
        String orgField = this.psd2Attributes.buildOrgField();
        this.addSubjectField(subjectFields, new ASN1ObjectIdentifier("2.5.4.97"), orgField, true);
    }
}

