/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.seal;

import com.anf.cert.profile.SealProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.SealAttributes;
import com.anf.cert.profile.impl.BaselineCertProfile;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;

public class SealProfileImpl
extends BaselineCertProfile
implements SealProfile {
    protected SealAttributes sealAttributes;

    public SealProfileImpl() {
    }

    public SealProfileImpl(CertAttributes certAttributes, SealAttributes sealAttributes) {
        super(certAttributes);
        this.sealAttributes = sealAttributes;
        this.init();
    }

    @Override
    public void init() {
        super.init();
        if (this.sealAttributes.getCommonName() != null) {
            this.certAttributes.setCommonName(this.sealAttributes.getCommonName());
        }
    }

    @Override
    protected ProfilePolicy profilePolicy() {
        return ProfilePolicy.QSeal_Software;
    }

    @Override
    public SealAttributes getSealAttributes() {
        return this.sealAttributes;
    }

    @Override
    @JsonIgnore
    public int getKeyLength() {
        return this.certAttributes.getKeySize();
    }

    @Override
    public String getTypeName() {
        return "QSEALC";
    }

    @Override
    @JsonIgnore
    public List<GeneralName> getSubjectAltNames() {
        ArrayList<GeneralName> names = new ArrayList<GeneralName>();
        if (this.sealAttributes.getEmail() != null) {
            names.add(new GeneralName(1, this.sealAttributes.getEmail()));
        }
        return names;
    }

    @Override
    @JsonIgnore
    public List<RDN> createSubjectFields() {
        ArrayList<RDN> subjectFields = new ArrayList<RDN>();
        this.addFirstSubjectFields(subjectFields);
        this.addSubjectField(subjectFields, BCStyle.C, this.certAttributes.getCountry(), true);
        this.addSubjectField(subjectFields, BCStyle.ST, this.certAttributes.getState(), true);
        this.addSubjectField(subjectFields, BCStyle.L, this.certAttributes.getCity(), true);
        this.addSubjectField(subjectFields, BCStyle.O, this.certAttributes.getOrganization(), true);
        this.addSubjectField(subjectFields, BCStyle.OU, this.certAttributes.getDepartment(), true);
        this.addLastSubjectFields(subjectFields);
        return subjectFields;
    }

    @Override
    protected void addFirstSubjectFields(List<RDN> subjectFields) {
        this.addSubjectField(subjectFields, BCStyle.SERIALNUMBER, this.certAttributes.getSerialNumber(), true);
    }

    @Override
    protected void addLastSubjectFields(List<RDN> subjectFields) {
        if (this.sealAttributes != null) {
            String commonName = this.sealAttributes.getCommonName();
            if (commonName == null || commonName.isEmpty()) {
                commonName = this.certAttributes.getCommonName();
            }
            this.addSubjectField(subjectFields, BCStyle.CN, this.sealAttributes.getCommonName(), true);
            this.addCIF(subjectFields);
        }
    }

    protected void addCIF(List<RDN> subjectFields) {
        if (this.certAttributes.getCountry() != null && this.certAttributes.getSerialNumber() != null) {
            this.addSubjectField(subjectFields, new ASN1ObjectIdentifier("2.5.4.97"), "VAT" + this.certAttributes.getCountry() + "-" + this.certAttributes.getSerialNumber(), true);
        }
    }

    @Override
    public void addSubjectField(List<RDN> subjectFields, ASN1ObjectIdentifier oid, String field, boolean verifyLength) {
        verifyLength = !oid.equals((ASN1Primitive)BCStyle.O) && !oid.equals((ASN1Primitive)BCStyle.OU) && !oid.equals((ASN1Primitive)BCStyle.CN);
        super.addSubjectField(subjectFields, oid, field, verifyLength);
    }

    @Override
    public boolean includeQcStatements() {
        return true;
    }
}

