/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl;

import com.anf.cert.profile.ContactInfo;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.encoding.SubjectAttributesEncodingController;
import com.anf.cert.profile.exception.InvalidTimeUnitException;
import com.anf.cert.profile.extensions.CertExtension;
import com.anf.cryptotoken.oid.IANACode;
import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

public abstract class BaselineCertProfile {
    protected CertAttributes certAttributes;
    protected ContactInfo contact;
    protected String policyOid;
    @JsonAlias(value={"test"})
    protected boolean testCertificate = true;
    protected int validity = 730;
    protected String validityUnit = TimeUnit.DAYS.name();
    protected Set<CertExtension> extensions = new TreeSet<CertExtension>();
    protected Date expiratioDate;
    protected String iana = IANACode.ANF_ES.getIanaCode();

    protected BaselineCertProfile() {
    }

    protected BaselineCertProfile(CertAttributes certAttributes) {
        this.certAttributes = certAttributes;
    }

    protected BaselineCertProfile(CertAttributes certAttributes, ContactInfo contact, int validity, String validityUnit) {
        this.certAttributes = certAttributes;
        this.contact = contact;
        this.validity = validity;
        this.validityUnit = validityUnit;
    }

    public String getIana() {
        return this.iana;
    }

    public void setIana(String iana) {
        this.iana = iana;
    }

    public Date getExpiratioDate() {
        return this.expiratioDate;
    }

    public void setExpirationDate(Date date) {
        this.expiratioDate = date;
    }

    public String getPolicyOid() {
        return this.policyOid;
    }

    public void setPolicyOid(String policyOid) {
        this.policyOid = policyOid;
    }

    public CertAttributes getCertAttributes() {
        return this.certAttributes;
    }

    public boolean isTestCertificate() {
        return this.testCertificate;
    }

    public void setTestCertificate(boolean testCertificate) {
        this.testCertificate = testCertificate;
    }

    public void addSubjectField(List<RDN> subjectFields, ASN1ObjectIdentifier oid, String field, boolean verifyLength) {
        ASN1Encodable value;
        if (field != null && !field.isEmpty() && (value = SubjectAttributesEncodingController.getDERString(oid, field, verifyLength)) != null) {
            subjectFields.add(new RDN(oid, value));
        }
    }

    public void init() {
        if (this.policyOid == null) {
            this.updatePolicy();
        }
    }

    public void updatePolicy() {
        this.updatePolicy(this.profilePolicy());
    }

    public void updatePolicy(ProfilePolicy profilePolicy) {
        this.policyOid = PolicyOID.fromIANACode((String)this.iana).oid(profilePolicy);
    }

    public void setCertAttributes(CertAttributes certAttributes) {
        this.certAttributes = certAttributes;
    }

    public List<RDN> createSubjectFields() {
        ArrayList<RDN> subjectFields = new ArrayList<RDN>();
        this.addFirstSubjectFields(subjectFields);
        this.addSubjectField(subjectFields, BCStyle.SERIALNUMBER, this.certAttributes.getSerialNumber(), true);
        this.addSubjectField(subjectFields, BCStyle.C, this.certAttributes.getCountry(), true);
        this.addSubjectField(subjectFields, BCStyle.ST, this.certAttributes.getState(), true);
        this.addSubjectField(subjectFields, BCStyle.L, this.certAttributes.getCity(), true);
        this.addSubjectField(subjectFields, BCStyle.O, this.certAttributes.getOrganization(), true);
        this.addSubjectField(subjectFields, BCStyle.ORGANIZATION_IDENTIFIER, this.certAttributes.getOrgId(), true);
        this.addSubjectField(subjectFields, BCStyle.OU, this.getOrganizationalUnit(), true);
        this.addLastSubjectFields(subjectFields);
        return subjectFields;
    }

    protected String getOrganizationalUnit() {
        return this.certAttributes.getDepartment();
    }

    public X500Name createSubject() {
        List<RDN> subjectFields = this.createSubjectFields();
        RDN[] rdns = new RDN[subjectFields.size()];
        return new X500Name(subjectFields.toArray(rdns));
    }

    protected abstract ProfilePolicy profilePolicy();

    protected void addLastSubjectFields(List<RDN> subjectFields) {
    }

    protected void addFirstSubjectFields(List<RDN> subjectFields) {
    }

    public ContactInfo getContact() {
        return this.contact;
    }

    public void setContact(ContactInfo contact) {
        this.contact = contact;
    }

    public int getValidity() {
        return this.validity;
    }

    public String getValidityUnit() {
        return this.validityUnit;
    }

    public void setValidity(int validity) {
        this.validity = validity;
    }

    public void setValidityUnit(String validityUnit) {
        try {
            ValidityUnits valid = ValidityUnits.valueOf(validityUnit);
            this.validityUnit = valid.name();
        }
        catch (Exception e) {
            throw new InvalidTimeUnitException(e);
        }
    }

    @JsonIgnore
    public Set<CertExtension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new TreeSet<CertExtension>();
        }
        return this.extensions;
    }

    public void addExtension(CertExtension extension) {
        this.getExtensions().add(extension);
    }

    private static enum ValidityUnits {
        SECOND,
        SECONDS,
        MINUTE,
        MINUTES,
        HOUR,
        HOURS,
        DAY,
        DAYS,
        MONTH,
        MONTHS,
        YEAR,
        YEARS;

    }
}

