/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.attributes.impl;

import com.anf.cert.profile.attributes.PSD2Attributes;
import com.anf.cert.profile.attributes.exception.AttributeValidationException;
import com.anf.cryptotoken.oid.QcStatementsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public class PSD2AttributesImpl
implements PSD2Attributes {
    private String idNCA;
    private String nameNCA;
    private String authNumber;
    private String countryCode;
    private List<String> roles;

    public PSD2AttributesImpl() {
    }

    public PSD2AttributesImpl(String idNCA, String nameNCA, String authNumber, String countryCode, List<String> roles) {
        this.idNCA = idNCA;
        this.nameNCA = nameNCA;
        this.authNumber = authNumber;
        this.countryCode = countryCode;
        this.roles = roles;
    }

    @Override
    public String getIdNCA() {
        return this.idNCA;
    }

    @Override
    public void setIdNCA(String idNCA) {
        this.idNCA = idNCA;
    }

    @Override
    public String getNameNCA() {
        return this.nameNCA;
    }

    @Override
    public void setNameNCA(String nameNCA) {
        this.nameNCA = nameNCA;
    }

    @Override
    public String getAuthNumber() {
        return this.authNumber;
    }

    @Override
    public void setAuthNumber(String authNumber) {
        this.authNumber = authNumber;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public List<String> getRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        return this.roles;
    }

    @Override
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @Override
    public String buildOrgField() {
        return "PSD" + this.countryCode + "-" + this.idNCA + "-" + this.authNumber;
    }

    @Override
    @JsonIgnore
    public QCStatement getQcStatementsPSD2() {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        if (this.nameNCA == null) {
            throw new AttributeValidationException("ERR_PSD2_NAME_NCA_NULL");
        }
        if (this.countryCode == null) {
            throw new AttributeValidationException("ERR_PSD2_COUNTRY_NULL");
        }
        if (this.idNCA == null) {
            throw new AttributeValidationException("ERR_PSD2_IDNCA_NULL");
        }
        TreeMap rolesMap = new TreeMap();
        this.roles.forEach(role -> rolesMap.put(role.replace("PSP_", ""), role));
        QCStatement qcPSD2 = QcStatementsUtils.getQcPSD2(rolesMap, (String)this.nameNCA, (String)this.countryCode, (String)this.idNCA);
        return qcPSD2;
    }
}

