/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.attributes.encoding;

import com.anf.cert.profile.attributes.encoding.exception.SubjectFieldEncodingException;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class SubjectFieldLength {
    public static void validateLenth(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        int length = -1;
        try {
            length = value.toASN1Primitive().getEncoded().length;
        }
        catch (IOException e) {
            throw new SubjectFieldEncodingException("ERR_" + oid.getId() + "_LEGTH_FAILED", e);
        }
        int factor = SubjectFieldLength.determineExtendedFactor(length, value);
        SubjectFieldLength.validateField(length, oid, BCStyle.CN, 64 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.L, 128 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.ST, 128 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.STREET, 128 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.O, 64 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.OU, 64 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.T, 64 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.SN, 64 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.SERIALNUMBER, 64 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.EmailAddress, 255);
        SubjectFieldLength.validateField(length, oid, BCStyle.C, 2);
        SubjectFieldLength.validateField(length, oid, BCStyle.GIVENNAME, 64);
        SubjectFieldLength.validateField(length, oid, BCStyle.POSTAL_CODE, 40);
        SubjectFieldLength.validateField(length, oid, BCStyle.PSEUDONYM, 128 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.SURNAME, 40 * factor);
        SubjectFieldLength.validateField(length, oid, BCStyle.BUSINESS_CATEGORY, 128);
    }

    private static int determineExtendedFactor(int length, ASN1Encodable value) {
        int result = 1;
        if (value instanceof DERPrintableString || value instanceof DERIA5String) {
            result = 1;
        } else if (value instanceof DERUTF8String) {
            result = 4;
        }
        return result;
    }

    public static void validateField(int length, ASN1ObjectIdentifier oid, ASN1ObjectIdentifier target, int max) {
        if (oid.equals((ASN1Primitive)target) && length > max + 2) {
            throw new SubjectFieldEncodingException("ERR_" + oid.getId() + "_LEGTH_FAILED(MAX:" + max + ",LENGTH:" + length + ")");
        }
    }
}

