/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.attributes.encoding;

import com.anf.cert.profile.attributes.encoding.IA5StringEncoding;
import com.anf.cert.profile.attributes.encoding.PrintableStringEncoding;
import com.anf.cert.profile.attributes.encoding.SubjectFieldLength;
import com.anf.cert.profile.attributes.encoding.exception.SubjectFieldEncodingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class SubjectAttributesEncodingController {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ASN1Encodable getDERString(ASN1ObjectIdentifier oid, String value, boolean verifyLength) {
        DERIA5String result = null;
        if (oid.equals((ASN1Primitive)BCStyle.EmailAddress)) {
            if (!SubjectAttributesEncodingController.validateIA5String(value)) throw new SubjectFieldEncodingException("ERR_INVALID_EMAIL_ADDRESS_STRING");
            result = new DERIA5String(value);
        } else if (oid.equals((ASN1Primitive)BCStyle.C)) {
            if (!SubjectAttributesEncodingController.validateCountry(value)) throw new SubjectFieldEncodingException("ERR_INVALID_COUNTRY_FIELD_FORMAT");
            result = SubjectAttributesEncodingController.defaultValidation(value);
        } else if (oid.equals((ASN1Primitive)BCStyle.BUSINESS_CATEGORY)) {
            if (!SubjectAttributesEncodingController.validateUTF8String(value)) throw new SubjectFieldEncodingException("ERR_INVALID_BUSINESS_CATEGORY_FIELD_FORMAT");
            result = new DERUTF8String(value);
        } else if (oid.equals((ASN1Primitive)BCStyle.SERIALNUMBER)) {
            if (!SubjectAttributesEncodingController.validatePrintableString(value)) throw new SubjectFieldEncodingException("ERR_INVALID_SERIALNUMBER_FIELD_FORMAT");
            result = new DERPrintableString(value);
        } else {
            result = SubjectAttributesEncodingController.defaultValidation(value);
        }
        if (result == null) {
            throw new SubjectFieldEncodingException("ERR_INVALID_FIELD_FORMAT");
        }
        if (!verifyLength) return result;
        SubjectFieldLength.validateLenth(oid, (ASN1Encodable)result);
        return result;
    }

    public static ASN1Encodable defaultValidation(String value) throws SubjectFieldEncodingException {
        DERPrintableString result = null;
        if (SubjectAttributesEncodingController.validatePrintableString(value)) {
            result = new DERPrintableString(value);
        } else if (SubjectAttributesEncodingController.validateUTF8String(value)) {
            result = new DERUTF8String(value);
        } else {
            throw new SubjectFieldEncodingException("ERR_INVALID_FIELD_FORMAT");
        }
        return result;
    }

    private static boolean validateCountry(String value) {
        boolean code;
        boolean bl = code = value.length() == 2;
        if (code) {
            for (int i = 0; i < value.length(); ++i) {
                if (Character.isUpperCase(value.charAt(i))) continue;
                return false;
            }
        }
        return code;
    }

    private static boolean validateUTF8String(String value) {
        return true;
    }

    private static boolean validateIA5String(String value) {
        return IA5StringEncoding.validate(value);
    }

    private static boolean validatePrintableString(String value) {
        return PrintableStringEncoding.validate(value);
    }
}

