/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile;

import com.anf.cert.profile.APSealProfile;
import com.anf.cert.profile.CertProfile;
import com.anf.cert.profile.ContactInfo;
import com.anf.cert.profile.EVSSLProfile;
import com.anf.cert.profile.PSD2SSLProfile;
import com.anf.cert.profile.PSD2SealProfile;
import com.anf.cert.profile.SSLProfile;
import com.anf.cert.profile.SealProfile;
import com.anf.cert.profile.SedeProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.EVAttributes;
import com.anf.cert.profile.attributes.PSD2Attributes;
import com.anf.cert.profile.attributes.PersonAttributes;
import com.anf.cert.profile.attributes.SealAttributes;
import com.anf.cert.profile.attributes.SedeAttributes;
import com.anf.cert.profile.attributes.impl.CertAttributesImpl;
import com.anf.cert.profile.attributes.impl.EVAttributesImpl;
import com.anf.cert.profile.attributes.impl.PSD2AttributesImpl;
import com.anf.cert.profile.attributes.impl.PersonAttributesImpl;
import com.anf.cert.profile.attributes.impl.SealAttributesImpl;
import com.anf.cert.profile.attributes.impl.SedeAttributesImpl;
import com.anf.cert.profile.impl.ContactInfoImpl;
import com.anf.cert.profile.impl.seal.SealProfileAPAlto;
import com.anf.cert.profile.impl.seal.SealProfileAPMedio;
import com.anf.cert.profile.impl.seal.SealProfileImpl;
import com.anf.cert.profile.impl.seal.SealProfilePSD2;
import com.anf.cert.profile.impl.sede.SedeEVAltoProfile;
import com.anf.cert.profile.impl.sede.SedeEVMedioProfile;
import com.anf.cert.profile.impl.ssl.BaselineSSLProfile;
import com.anf.cert.profile.impl.ssl.DVSSLProfileImpl;
import com.anf.cert.profile.impl.ssl.EVSSLProfileImpl;
import com.anf.cert.profile.impl.ssl.IVSSLProfileImpl;
import com.anf.cert.profile.impl.ssl.OVSSLProfileImpl;
import com.anf.cert.profile.impl.ssl.PSD2SSLProfileImpl;
import com.anf.oauth.json.JSONFactory;

public class CertProfileFactory {
    public static Class<? extends CertProfile> getProfileClass(String type) {
        switch (type) {
            case "SSL_BASELINE": {
                return BaselineSSLProfile.class;
            }
            case "SSL_IV": {
                return IVSSLProfileImpl.class;
            }
            case "QWAC": 
            case "SSL_EV": {
                return EVSSLProfileImpl.class;
            }
            case "SSL_DV": {
                return DVSSLProfileImpl.class;
            }
            case "SSL_OV": {
                return OVSSLProfileImpl.class;
            }
            case "QWAC_PSD2": 
            case "SSL_PSD2": {
                return PSD2SSLProfileImpl.class;
            }
            case "QSEALC": {
                return SealProfileImpl.class;
            }
            case "QSEAL_PSD2": 
            case "QSEALC_PSD2": 
            case "SEAL_PSD2": {
                return SealProfilePSD2.class;
            }
            case "SEDE_EV": 
            case "SEDE_EV_MEDIO": {
                return SedeEVMedioProfile.class;
            }
            case "SEDE_EV_ALTO": {
                return SedeEVAltoProfile.class;
            }
            case "QSEAL_AP_MEDIO": {
                return SealProfileAPMedio.class;
            }
            case "QSEAL_AP_ALTO": {
                return SealProfileAPAlto.class;
            }
        }
        return null;
    }

    public static Class<? extends CertProfile> getProfileInterface(String type) {
        switch (type) {
            case "SSL_BASELINE": {
                return SSLProfile.class;
            }
            case "SSL_DV": {
                return DVSSLProfileImpl.class;
            }
            case "SSL_OV": {
                return OVSSLProfileImpl.class;
            }
            case "SSL_EV": {
                return EVSSLProfile.class;
            }
            case "SSL_PSD2": {
                return PSD2SSLProfile.class;
            }
            case "SEAL_PSD2": {
                return PSD2SealProfile.class;
            }
        }
        return null;
    }

    public static String toJson(CertProfile profile) {
        return JSONFactory.buildJSON((Object)profile, (String)"request");
    }

    public static CertProfile fromJson(String type, String json) {
        Class<? extends CertProfile> profileClass = CertProfileFactory.getProfileClass(type);
        CertProfile profile = (CertProfile)JSONFactory.buildObject((byte[])json.getBytes(), (String)"request", profileClass);
        profile.init();
        return profile;
    }

    public static EVSSLProfile buildSSLEV(CertAttributes certAttributes, EVAttributes evAttributes, String ... domains) {
        return new EVSSLProfileImpl(certAttributes, evAttributes, domains);
    }

    public static SSLProfile buildSSLDV(CertAttributes certAttributes, String ... domains) {
        return new DVSSLProfileImpl(certAttributes, domains);
    }

    public static SSLProfile buildSSLOV(CertAttributes certAttributes, String ... domains) {
        return new OVSSLProfileImpl(certAttributes, domains);
    }

    public static SedeProfile buildSedeEVMedio(CertAttributes certAttributes, SedeAttributes sedeAttributes, EVAttributes evAttributes, String ... domains) {
        return new SedeEVMedioProfile(certAttributes, sedeAttributes, evAttributes, domains);
    }

    public static SedeProfile buildSedeEVAlto(CertAttributes certAttributes, SedeAttributes sedeAttributes, EVAttributes evAttributes, String ... domains) {
        return new SedeEVAltoProfile(certAttributes, sedeAttributes, evAttributes, domains);
    }

    public static SSLProfile buildSSLIV(CertAttributes certAttributes, PersonAttributes personAttributes, String ... domains) {
        return new IVSSLProfileImpl(certAttributes, personAttributes, domains);
    }

    public static PSD2SSLProfile buildSSLPSD2(CertAttributes certAttributes, EVAttributes evAttributes, PSD2Attributes psd2Attributes, String ... domains) {
        return new PSD2SSLProfileImpl(certAttributes, evAttributes, psd2Attributes, domains);
    }

    public static PSD2SealProfile buildSealPSD2(CertAttributes certAttributes, SealAttributes sealAttributes, PSD2Attributes psd2Attributes) {
        return new SealProfilePSD2(certAttributes, sealAttributes, psd2Attributes);
    }

    public static SealProfile buildSeal(CertAttributes certAttributes, SealAttributes sealAttributes) {
        return new SealProfileImpl(certAttributes, sealAttributes);
    }

    public static APSealProfile buildSealAPMedio(CertAttributes certAttributes, SealAttributes sealAttributes) {
        return new SealProfileAPMedio(certAttributes, sealAttributes);
    }

    public static APSealProfile buildSealAPAlto(CertAttributes certAttributes, SealAttributes sealAttributes) {
        return new SealProfileAPAlto(certAttributes, sealAttributes);
    }

    static {
        JSONFactory.deserializeInterface(SedeAttributes.class, SedeAttributesImpl.class);
        JSONFactory.deserializeInterface(ContactInfo.class, ContactInfoImpl.class);
        JSONFactory.deserializeInterface(PersonAttributes.class, PersonAttributesImpl.class);
        JSONFactory.deserializeInterface(SealAttributes.class, SealAttributesImpl.class);
        JSONFactory.deserializeInterface(CertAttributes.class, CertAttributesImpl.class);
        JSONFactory.deserializeInterface(EVAttributes.class, EVAttributesImpl.class);
        JSONFactory.deserializeInterface(PSD2Attributes.class, PSD2AttributesImpl.class);
    }
}

