/*
 * Decompiled with CFR 0.152.
 */
package com.anf.centralizados.encoders;

import com.anf.centralizados.enums.EncodeType;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.bouncycastle.util.encoders.Hex;

public class X509CertificateEncoder {
    public static String encode(X509Certificate cert, EncodeType encode) throws CertificateEncodingException {
        if (encode == EncodeType.BASE64) {
            return X509CertificateEncoder.toBase64(cert);
        }
        return X509CertificateEncoder.toHex(cert);
    }

    public static String toHex(X509Certificate cert) throws CertificateEncodingException {
        return Hex.toHexString((byte[])cert.getEncoded());
    }

    public static String toBase64(X509Certificate cert) throws CertificateEncodingException {
        return Base64.getEncoder().encodeToString(cert.getEncoded());
    }

    public static String[] encode(X509Certificate[] cert, EncodeType encode) throws CertificateEncodingException {
        if (encode == EncodeType.BASE64) {
            return X509CertificateEncoder.toBase64(cert);
        }
        return X509CertificateEncoder.toHex(cert);
    }

    public static String[] toHex(X509Certificate[] cert) throws CertificateEncodingException {
        String[] result = new String[cert.length];
        for (int i = 0; i < cert.length; ++i) {
            result[i] = X509CertificateEncoder.toHex(cert[i]);
        }
        return result;
    }

    public static String[] toBase64(X509Certificate[] cert) throws CertificateEncodingException {
        String[] result = new String[cert.length];
        for (int i = 0; i < cert.length; ++i) {
            result[i] = X509CertificateEncoder.toBase64(cert[i]);
        }
        return result;
    }

    public static X509Certificate[] decode(String[] cert, EncodeType encode) throws CertificateException, NoSuchProviderException {
        if (encode == EncodeType.BASE64) {
            return X509CertificateEncoder.fromBase64(cert);
        }
        return X509CertificateEncoder.fromHex(cert);
    }

    public static X509Certificate[] fromHex(String[] cert) throws CertificateException, NoSuchProviderException {
        X509Certificate[] result = new X509Certificate[cert.length];
        for (int i = 0; i < cert.length; ++i) {
            result[i] = X509CertificateEncoder.fromHex(cert[i]);
        }
        return result;
    }

    public static X509Certificate[] fromBase64(String[] cert) throws CertificateException, NoSuchProviderException {
        X509Certificate[] result = new X509Certificate[cert.length];
        for (int i = 0; i < cert.length; ++i) {
            result[i] = X509CertificateEncoder.fromBase64(cert[i]);
        }
        return result;
    }

    public static X509Certificate decode(String cert, EncodeType encode) throws CertificateException, NoSuchProviderException {
        if (encode == EncodeType.BASE64) {
            return X509CertificateEncoder.fromBase64(cert);
        }
        return X509CertificateEncoder.fromHex(cert);
    }

    public static X509Certificate fromHex(String data) throws CertificateException, NoSuchProviderException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(Hex.decode((String)data)));
    }

    public static X509Certificate fromBase64(String data) throws CertificateException, NoSuchProviderException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(data)));
    }
}

