/*
 * Decompiled with CFR 0.152.
 */
package com.anf.centralizados.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class CertificateConverterBase {
    public static X509Certificate fromDER(byte[] certData) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certData));
    }

    public static byte[] toDER(X509Certificate cert) throws Exception {
        return cert.getEncoded();
    }

    public static X509Certificate fromPEM(byte[] certData) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certData));
    }

    public static byte[] toPEM(X509Certificate cert) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(out));){
            jcaPEMWriter.writeObject((Object)cert);
        }
        return out.toByteArray();
    }

    public static List<X509Certificate> fromDERList(List<byte[]> certsData, List<X509Certificate> res) throws Exception {
        for (byte[] certData : certsData) {
            res.add(CertificateConverterBase.fromDER(certData));
        }
        return res;
    }

    public static List<byte[]> toDERList(List<X509Certificate> certs, List<byte[]> res) throws Exception {
        for (X509Certificate cert : certs) {
            res.add(CertificateConverterBase.toDER(cert));
        }
        return res;
    }

    public static List<X509Certificate> fromPEMList(List<byte[]> certsData, List<X509Certificate> res) throws Exception {
        for (byte[] cert : certsData) {
            res.add(CertificateConverterBase.fromPEM(cert));
        }
        return res;
    }

    public static List<byte[]> toPEMList(List<X509Certificate> certs, List<byte[]> res) throws Exception {
        for (X509Certificate cert : certs) {
            res.add(CertificateConverterBase.toPEM(cert));
        }
        return res;
    }
}

