/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCFilenameFactory;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESFilenameFactory;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import java.util.List;
import java.util.Objects;

public class DefaultASiCWithXAdESFilenameFactory
extends AbstractASiCFilenameFactory
implements ASiCWithXAdESFilenameFactory {
    private static final long serialVersionUID = -3252975270136045191L;

    public String getSignatureFilename(ASiCContent asicContent) {
        this.assertASiCContentIsValid(asicContent);
        if (ASiCUtils.isASiCSContainer((ASiCContent)asicContent)) {
            return "META-INF/signatures.xml";
        }
        if (ASiCUtils.isOpenDocument((DSSDocument)asicContent.getMimeTypeDocument())) {
            return "META-INF/documentsignatures.xml";
        }
        List existingSignatureNames = DSSUtils.getDocumentNames((List)asicContent.getSignatureDocuments());
        return this.getNextAvailableDocumentName("META-INF/signatures001.xml", existingSignatureNames);
    }

    public String getManifestFilename(ASiCContent asicContent) {
        return "META-INF/manifest.xml";
    }

    public String getDataPackageFilename(ASiCContent asicContent) {
        return "package.zip";
    }

    public String getEvidenceRecordFilename(ASiCContent asicContent, EvidenceRecordTypeEnum evidenceRecordType) {
        Objects.requireNonNull(evidenceRecordType, "EvidenceRecordType shall be defined!");
        this.assertASiCContentIsValid(asicContent);
        switch (evidenceRecordType) {
            case XML_EVIDENCE_RECORD: {
                return "META-INF/evidencerecord.xml";
            }
            case ASN1_EVIDENCE_RECORD: {
                return "META-INF/evidencerecord.ers";
            }
        }
        throw new UnsupportedOperationException(String.format("The Evidence Record Type '%s' is not supported!", evidenceRecordType));
    }

    public String getEvidenceRecordManifestFilename(ASiCContent asicContent) {
        this.assertASiCContentIsValid(asicContent);
        List existingManifestNames = DSSUtils.getDocumentNames((List)asicContent.getEvidenceRecordManifestDocuments());
        return this.getNextAvailableDocumentName("META-INF/ASiCEvidenceRecordManifest001.xml", existingManifestNames);
    }
}

