/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.extract;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.model.DSSDocument;

public class ASiCWithXAdESContainerExtractor
extends DefaultASiCContainerExtractor {
    private static final String METAINF_MANIFEST_FILENAME = "META-INF/manifest.xml";

    public ASiCWithXAdESContainerExtractor(DSSDocument archive) {
        super(archive);
    }

    protected boolean isAllowedManifest(String entryName) {
        return entryName.equals(METAINF_MANIFEST_FILENAME);
    }

    protected boolean isAllowedArchiveManifest(String entryName) {
        return false;
    }

    protected boolean isAllowedEvidenceRecordManifest(String entryName) {
        return ASiCUtils.isEvidenceRecordManifest((String)entryName);
    }

    protected boolean isAllowedSignature(String entryName) {
        return ASiCUtils.isXAdES((String)entryName);
    }

    protected boolean isAllowedTimestamp(String entryName) {
        return false;
    }

    protected boolean isAllowedEvidenceRecord(String entryName) {
        return "META-INF/evidencerecord.ers".equals(entryName) || "META-INF/evidencerecord.xml".equals(entryName);
    }
}

