/*
 * Decompiled with CFR 0.152.
 */
package com.anf.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public interface VersionControl {
    public static final String version = VersionControl.getVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion() {
        String version = null;
        Model model = null;
        InputStream stream = null;
        try {
            String resource = "/META-INF/maven/com.anf.crypto.core/ANFCryptoCore/pom.xml";
            stream = VersionControl.class.getResourceAsStream(resource);
            File pomFile = new File("pom.xml");
            if (stream == null && pomFile.exists()) {
                stream = new FileInputStream(pomFile);
            }
            System.out.println("maven resource:" + stream);
            if (stream != null) {
                System.out.println("maven stream not null");
                try {
                    MavenXpp3Reader reader = new MavenXpp3Reader();
                    model = reader.read(stream);
                    System.out.println("model from stream ok");
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
            } else {
                model = new Model();
                model.setVersion("2.X.X");
            }
            if (model != null) {
                version = model.getVersion();
            }
            if (version == null && model.getParent() != null) {
                version = model.getParent().getVersion();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (version == null) {
            return "2.X.X";
        }
        return version;
    }
}

